/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.game2d.editor;

import com.spacekiller.game2d.Element;
import com.spacekiller.game2d.ElementView;
import com.spacekiller.game2d.Rect;
import java.awt.Color;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.JPanel;

public class ViewPanel
extends JPanel {
    private ElementView view;
    private Collection selectedElements = new ArrayList();

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.view != null) {
            this.view.paint(g);
            g.setColor(Color.WHITE);
            Iterator i = this.getSelectedElements();
            while (i.hasNext()) {
                Element sel = (Element)i.next();
                Rect viewRect = this.view.getViewRect();
                g.drawRect((int)(sel.getX() - viewRect.getX()), (int)(sel.getY() - viewRect.getY()), (int)sel.getWidth(), (int)sel.getHeight());
            }
        }
    }

    public ElementView getView() {
        return this.view;
    }

    public void setView(ElementView view) {
        this.view = view;
    }

    public Iterator getSelectedElements() {
        return this.selectedElements.iterator();
    }

    public int getSelectedElementCount() {
        return this.selectedElements.size();
    }

    public boolean isSelectedElement(Element e) {
        return this.selectedElements.contains(e);
    }

    public void addSelectedElement(Element element) {
        if (element != null && !this.selectedElements.contains(element)) {
            this.selectedElements.add(element);
        }
    }

    public void removeSelectedElement(Element element) {
        this.selectedElements.remove(element);
    }

    public void removeAllSelectedElements() {
        this.selectedElements.clear();
    }
}

