/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.collect;

public class Int2IntMap {
    private int nullValue;
    private int[] ids;
    private int[] ofs;
    private int len;
    private int size;
    private int threshold;
    private boolean zeroSet;
    private int zeroValue;

    public Int2IntMap(int nullValue, int initCapacity) {
        this.nullValue = nullValue;
        this.ids = new int[initCapacity];
        this.ofs = new int[initCapacity];
        this.len = initCapacity;
        this.threshold = this.len * 2 / 3;
        this.size = 0;
    }

    public int capacity() {
        return this.len;
    }

    private void closeDeletion(int d) {
        int key;
        int i = this.next(d);
        while ((key = this.ids[i]) != 0) {
            int r = (key & Integer.MAX_VALUE) % this.len;
            if (i < r && (r <= d || d <= i) || r <= d && d <= i) {
                this.ids[d] = key;
                this.ofs[d] = this.ofs[i];
                this.ids[i] = 0;
                this.ofs[i] = 0;
                d = i;
            }
            i = this.next(i);
        }
    }

    public int get(int id) {
        if (id == 0) {
            return this.zeroSet ? this.zeroValue : this.nullValue;
        }
        int i = (id & Integer.MAX_VALUE) % this.len;
        int v;
        while ((v = this.ids[i]) != 0) {
            if (v == id) {
                return this.ofs[i];
            }
            i = this.next(i);
        }
        return this.nullValue;
    }

    public boolean has(int id) {
        if (id == 0) {
            return this.zeroSet;
        }
        int i = (id & Integer.MAX_VALUE) % this.len;
        int v;
        while ((v = this.ids[i]) != 0) {
            if (v == id) {
                return true;
            }
            i = this.next(i);
        }
        return false;
    }

    public int getUsedMemory() {
        int rc = this.capacity() * 8;
        return rc += 24;
    }

    private int next(int i) {
        return ++i < this.len ? i : 0;
    }

    public void remove(int id) {
        int key;
        if (id == 0) {
            if (this.zeroSet) {
                this.zeroSet = false;
                --this.size;
            }
            return;
        }
        int i = (id & Integer.MAX_VALUE) % this.len;
        while ((key = this.ids[i]) != 0) {
            if (key == id) {
                this.ids[i] = 0;
                this.ofs[i] = 0;
                this.closeDeletion(i);
                return;
            }
            i = this.next(i);
        }
    }

    private void resize(int newLen) {
        if (newLen < this.len) {
            return;
        }
        int[] oldIds = this.ids;
        int[] oldOfs = this.ofs;
        int oldLen = this.len;
        this.ids = new int[newLen];
        this.ofs = new int[newLen];
        this.len = newLen;
        this.threshold = this.len * 2 / 3;
        for (int j = 0; j < oldLen; ++j) {
            int id = oldIds[j];
            if (id == 0) continue;
            int i = (id & Integer.MAX_VALUE) % this.len;
            while (this.ids[i] != 0) {
                i = this.next(i);
            }
            this.ids[i] = id;
            this.ofs[i] = oldOfs[j];
        }
    }

    public void set(int id, int off) {
        int v;
        if (id == 0) {
            if (this.zeroSet) {
                this.zeroValue = off;
            } else {
                this.zeroSet = true;
                this.zeroValue = off;
                ++this.size;
            }
            return;
        }
        int i = (id & Integer.MAX_VALUE) % this.len;
        while ((v = this.ids[i]) != 0) {
            if (v == id) {
                this.ofs[i] = off;
                return;
            }
            i = this.next(i);
        }
        this.ids[i] = id;
        this.ofs[i] = off;
        if (++this.size >= this.threshold) {
            this.resize(this.len * 2);
        }
    }

    public int size() {
        return this.size;
    }

    public void clear() {
        if (this.zeroSet) {
            this.zeroSet = false;
            --this.size;
        }
        if (this.size != 0) {
            for (int i = 0; i < this.len; ++i) {
                this.ids[i] = 0;
                this.ofs[i] = 0;
            }
            this.size = 0;
        }
    }
}

