/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.collect;

public class Object2LongMap<K> {
    private long notFound;
    private K[] obj;
    private long[] ids;
    private int len;
    private int size;
    private int threshold;
    private boolean nullSet;
    private long nullValue;

    public Object2LongMap(int initCapacity, long notFoundValue) {
        this.notFound = notFoundValue;
        this.obj = new Object[initCapacity];
        this.ids = new long[initCapacity];
        this.len = initCapacity;
        this.threshold = this.len * 2 / 3;
        this.nullSet = false;
        this.size = 0;
    }

    protected int hash(Object o) {
        return o.hashCode();
    }

    protected boolean compare(K a, K b) {
        return a.equals(b);
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size < 1;
    }

    private int next(int i) {
        return ++i < this.len ? i : 0;
    }

    public boolean containsKey(K key) {
        if (key == null) {
            return this.nullSet;
        }
        int i = this.hash(key) % this.len;
        K k;
        while ((k = this.obj[i]) != null) {
            if (this.compare(k, key)) {
                return true;
            }
            i = this.next(i);
        }
        return false;
    }

    public long get(K key) {
        if (key == null) {
            return this.nullSet ? this.nullValue : this.notFound;
        }
        int i = this.hash(key) % this.len;
        K k;
        while ((k = this.obj[i]) != null) {
            if (this.compare(k, key)) {
                return this.ids[i];
            }
            i = this.next(i);
        }
        return this.notFound;
    }

    public void put(K key, long value) {
        K k;
        if (key == null) {
            if (this.nullSet) {
                this.nullValue = value;
            } else {
                this.nullSet = true;
                this.nullValue = value;
                ++this.size;
            }
            return;
        }
        int i = this.hash(key) % this.len;
        while ((k = this.obj[i]) != null) {
            if (this.compare(k, key)) {
                this.ids[i] = value;
                return;
            }
            i = this.next(i);
        }
        this.obj[i] = key;
        this.ids[i] = value;
        if (++this.size >= this.threshold) {
            this.resize(this.len * 2);
        }
    }

    private void resize(int newLen) {
        if (newLen < this.len) {
            return;
        }
        long[] oldIds = this.ids;
        K[] oldObj = this.obj;
        int oldLen = this.len;
        this.ids = new long[newLen];
        this.obj = new Object[newLen];
        this.len = newLen;
        this.threshold = this.len * 2 / 3;
        for (int j = 0; j < oldLen; ++j) {
            K k = oldObj[j];
            if (k == null) continue;
            int i = this.hash(k) % this.len;
            while (this.obj[i] != null) {
                i = this.next(i);
            }
            this.obj[i] = k;
            this.ids[i] = oldIds[j];
        }
    }

    public long remove(K key) {
        K k;
        if (key == null) {
            if (this.nullSet) {
                long rc = this.nullValue;
                this.nullSet = false;
                --this.size;
                return rc;
            }
            return this.notFound;
        }
        int i = this.hash(key) % this.len;
        while ((k = this.obj[i]) != null) {
            if (this.compare(k, key)) {
                long rc = this.ids[i];
                this.obj[i] = null;
                this.ids[i] = 0L;
                --this.size;
                this.closeDeletion(i);
                return rc;
            }
            i = this.next(i);
        }
        return this.notFound;
    }

    private void closeDeletion(int d) {
        K k;
        int i = this.next(d);
        while ((k = this.obj[i]) != null) {
            int r = this.hash(k) % this.len;
            if (i < r && (r <= d || d <= i) || r <= d && d <= i) {
                this.obj[d] = k;
                this.ids[d] = this.ids[i];
                this.obj[i] = null;
                this.ids[i] = 0L;
                d = i;
            }
            i = this.next(i);
        }
    }

    public void clear() {
        if (this.nullSet) {
            this.nullSet = false;
            --this.size;
        }
        if (this.size != 0) {
            for (int i = 0; i < this.len; ++i) {
                this.obj[i] = null;
            }
            this.size = 0;
        }
    }
}

