/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.collect;

import com.spacekiller.util.collect.Iterators;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;

public class ObjectQueue
implements Collection {
    private int partLen;
    private int size;
    private LinkedList parts;
    private Part firstPart;
    private Part lastPart;
    private LinkedList recycle = null;

    public ObjectQueue(int incrementCapacity) {
        Part p;
        this.partLen = incrementCapacity;
        this.parts = new LinkedList();
        this.firstPart = p = new Part(this.partLen);
        this.lastPart = p;
        this.parts.add(p);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size < 1;
    }

    public boolean add(Object o) {
        Part p;
        if (this.lastPart.add(o)) {
            ++this.size;
            return true;
        }
        if (this.recycle == null) {
            p = new Part(this.partLen);
        } else {
            p = null;
            while (!this.recycle.isEmpty() && (p = (Part)((Reference)this.recycle.removeFirst()).get()) == null) {
            }
            if (p == null) {
                this.recycle = null;
                p = new Part(this.partLen);
            }
            this.lastPart = p;
        }
        this.parts.add(p);
        this.lastPart = p;
        p.add(o);
        ++this.size;
        return true;
    }

    public boolean addAll(Collection arg0) {
        throw new UnsupportedOperationException("TODO");
    }

    public Object remove() {
        if (this.size < 1) {
            return null;
        }
        if (this.firstPart.size > 0) {
            --this.size;
            return this.firstPart.remove();
        }
        if (this.recycle == null) {
            this.recycle = new LinkedList();
        }
        this.recycle.add(new SoftReference<Part>(this.firstPart));
        this.parts.remove(0);
        this.firstPart = (Part)this.parts.getFirst();
        --this.size;
        return this.firstPart.remove();
    }

    @Override
    public void clear() {
        if (this.size != 0) {
            Iterator i = this.parts.iterator();
            while (i.hasNext()) {
                ((Part)i.next()).clear();
            }
            this.size = 0;
        }
        if (this.firstPart != this.lastPart) {
            if (this.recycle == null) {
                this.recycle = new LinkedList();
            }
            this.parts.removeFirst();
            for (Part p : this.parts) {
                this.recycle.add(new SoftReference<Part>(p));
            }
            this.lastPart = this.firstPart;
            this.parts.clear();
            this.parts.add(this.firstPart);
        }
    }

    public void release() {
        this.recycle = null;
    }

    public int computeCapacity() {
        int cap = 0;
        Iterator i = this.parts.iterator();
        while (i.hasNext()) {
            cap += ((Part)i.next()).len;
        }
        if (this.recycle != null) {
            Iterator i2 = this.recycle.iterator();
            while (i2.hasNext()) {
                Part p = (Part)((Reference)i2.next()).get();
                if (p == null) continue;
                cap += p.len;
            }
        }
        return cap;
    }

    @Override
    public Iterator iterator() {
        if (this.size > 0) {
            return new Iter();
        }
        return Iterators.EMPTY_ITERATOR;
    }

    @Override
    public boolean contains(Object o) {
        throw new UnsupportedOperationException("TODO");
    }

    public boolean containsAll(Collection arg0) {
        throw new UnsupportedOperationException("TODO");
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException("TODO");
    }

    public boolean removeAll(Collection arg0) {
        throw new UnsupportedOperationException("TODO");
    }

    public boolean retainAll(Collection arg0) {
        throw new UnsupportedOperationException("TODO");
    }

    @Override
    public Object[] toArray() {
        throw new UnsupportedOperationException("TODO");
    }

    public Object[] toArray(Object[] arg0) {
        throw new UnsupportedOperationException("TODO");
    }

    protected class Iter
    implements Iterator {
        private Iterator partIter;
        private Part part;
        private Object[] arr;
        private int ofs;
        private int end;

        public Iter() {
            if (ObjectQueue.this.firstPart != null) {
                this.partIter = ObjectQueue.this.parts.iterator();
                this.part = (Part)this.partIter.next();
                this.arr = this.part.array;
                this.ofs = this.part.head;
                int t = this.part.tail;
                this.end = this.ofs < t ? t : this.part.len;
            } else {
                this.partIter = null;
                this.arr = null;
                this.ofs = 0;
                this.end = 0;
            }
        }

        @Override
        public boolean hasNext() {
            return this.ofs < this.end;
        }

        public Object next() {
            Object o = this.arr[this.ofs++];
            if (this.ofs >= this.end) {
                if (this.end == this.part.len && this.part.head > this.part.tail && this.part.tail > 0) {
                    this.ofs = 0;
                    this.end = this.part.tail;
                } else if (this.partIter.hasNext()) {
                    this.part = (Part)this.partIter.next();
                    this.arr = this.part.array;
                    this.ofs = this.part.head;
                    int t = this.part.tail;
                    this.end = this.ofs < t ? t : this.part.len;
                }
            }
            return o;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("TODO");
        }
    }

    protected static class Part {
        private Object[] array;
        private int len;
        private int size;
        private int head;
        private int tail;

        public Part(int partLen) {
            this.len = partLen;
            this.array = new Object[this.len];
            this.head = 0;
            this.tail = 0;
            this.size = 0;
        }

        protected Object remove() {
            Object o = this.array[this.head];
            this.array[this.head] = null;
            ++this.head;
            this.head %= this.len;
            --this.size;
            return o;
        }

        protected boolean add(Object o) {
            if (this.size < this.len) {
                this.array[this.tail] = o;
                ++this.tail;
                this.tail %= this.len;
                ++this.size;
                return true;
            }
            return false;
        }

        protected void clear() {
            if (this.size != 0) {
                if (this.head < this.tail) {
                    for (int i = this.head; i < this.tail; ++i) {
                        this.array[i] = null;
                    }
                } else {
                    int i;
                    for (i = this.head; i < this.len; ++i) {
                        this.array[i] = null;
                    }
                    for (i = 0; i < this.tail; ++i) {
                        this.array[i] = null;
                    }
                }
                this.size = 0;
            }
            this.head = 0;
            this.tail = 0;
        }
    }
}

