/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.locale;

import com.spacekiller.util.Tools;
import com.spacekiller.util.locale.CountryChooser;
import com.spacekiller.util.locale.LocaleUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyEditorSupport;
import java.util.Locale;
import javax.swing.Icon;
import javax.swing.JPanel;

public class CountryPropertyEditor
extends PropertyEditorSupport {
    private static JPanel dummy = new JPanel();
    private Color textColor = Color.BLACK;
    private Font textFont = dummy.getFont();

    @Override
    public String getJavaInitializationString() {
        Object value = this.getValue();
        String s = value == null ? null : String.valueOf(value);
        return Tools.quoteJava((String)s);
    }

    @Override
    public boolean isPaintable() {
        return true;
    }

    @Override
    public void paintValue(Graphics g, Rectangle box) {
        super.paintValue(g, box);
        Icon icon = null;
        String text = null;
        Object value = this.getValue();
        if (value != null) {
            String country = String.valueOf(value);
            Locale locale = new Locale("", country);
            text = locale.getDisplayCountry();
            icon = LocaleUtil.getInstance().getCountryIcon(country);
        }
        int h = box.height;
        int x = 0;
        int y = 0;
        if (icon != null) {
            int iw = icon.getIconWidth();
            int ih = icon.getIconHeight();
            icon.paintIcon(dummy, g, x, h / 2 - ih / 2);
            x += iw;
        }
        if (text != null) {
            Font font = this.getTextFont();
            g.setFont(font);
            FontMetrics fm = g.getFontMetrics();
            g.setColor(this.getTextColor());
            g.drawString(text, x + 4, y + fm.getAscent());
        }
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public void setTextColor(Color textColor) {
        this.textColor = textColor;
    }

    public Font getTextFont() {
        return this.textFont;
    }

    public void setTextFont(Font textFont) {
        this.textFont = textFont;
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    @Override
    public Component getCustomEditor() {
        final CountryChooser chooser = new CountryChooser();
        chooser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String country = chooser.getSelectedCountry();
                CountryPropertyEditor.this.setValue(country);
            }
        });
        return chooser;
    }
}

