/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.infection.plugin.log;

import com.spacekiller.infection.plugin.log.LogView;
import com.spacekiller.util.BeansToolkit;
import com.spacekiller.util.Platform;
import com.spacekiller.util.tooling.ToolGroup;
import com.spacekiller.util.workbench.DefaultViewProvider;
import com.spacekiller.util.workbench.View;
import com.spacekiller.util.workbench.WorkbenchPlugin;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LogViewProvider
extends DefaultViewProvider {
    private static final Logger logger = Logger.getLogger(LogViewProvider.class.getName());
    private ToolGroup toolbarGroup;

    protected void initView(View v) {
        super.initView(v);
        if (v instanceof LogView) {
            LogView tv = (LogView)v;
            tv.setTitle(this.getName());
            tv.setTooltip(this.getTooltip());
            tv.setIcon(this.getIcon());
            try {
                Platform platform = Platform.getInstance();
                WorkbenchPlugin plugin = (WorkbenchPlugin)platform.getPlugin("com.spacekiller.util.workbench.WorkbenchPlugin");
                logger.fine("WorkbenchPlugin: " + plugin);
                BeansToolkit btk = platform.getBeansToolkit();
                logger.fine("BeansToolkit: " + btk);
                tv.setToolbarGroup(this.toolbarGroup);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }

    public ToolGroup getToolbarGroup() {
        return this.toolbarGroup;
    }

    public void setToolbarGroup(ToolGroup toolbarGroup) {
        this.toolbarGroup = toolbarGroup;
    }
}

