/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.infection.plugin.run;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RunConfig
implements Runnable,
Serializable {
    private static final long serialVersionUID = 1721869667331475248L;
    private String title;
    private String tooltip;
    private long lastRunTime;
    private String className;
    private String arguments;
    private static final Logger logger = Logger.getLogger(RunConfig.class.getName());

    public RunConfig() {
    }

    public RunConfig(String className, String arguments) {
        this();
        this.setClassName(className);
        this.setArguments(arguments);
    }

    @Override
    public void run() {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(this.className);
        }
        catch (Throwable e) {
            this.handleException(e);
        }
        Method mainMethod = null;
        try {
            mainMethod = clazz.getDeclaredMethod("main", String[].class);
            int mod = mainMethod.getModifiers();
            if (!Modifier.isPublic(mod)) {
                throw new Exception("Method main must be public");
            }
            if (!Modifier.isStatic(mod)) {
                throw new Exception("Method main must be static");
            }
        }
        catch (Throwable e) {
            this.handleException(e);
        }
        try {
            String[] args = this.parseArguments(this.arguments);
            mainMethod.invoke(null, new Object[]{args});
        }
        catch (Throwable e) {
            this.handleException(e);
        }
    }

    protected String[] parseArguments(String s) {
        if (s == null) {
            return new String[0];
        }
        String delim = " \r\n\t";
        StringTokenizer tok = new StringTokenizer(s, delim, false);
        ArrayList<String> args = new ArrayList<String>();
        while (tok.hasMoreTokens()) {
            args.add(tok.nextToken());
        }
        return args.toArray(new String[args.size()]);
    }

    protected void handleException(Throwable e) {
        logger.log(Level.SEVERE, e.getMessage(), e);
    }

    public String getArguments() {
        return this.arguments;
    }

    public void setArguments(String arguments) {
        this.arguments = arguments;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String toString() {
        return String.valueOf(this.title);
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public void setTooltip(String tooltip) {
        this.tooltip = tooltip;
    }

    public long getLastRunTime() {
        return this.lastRunTime;
    }

    public void setLastRunTime(long lastRunTime) {
        this.lastRunTime = lastRunTime;
    }
}

