/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.infection.plugin.run;

import com.spacekiller.infection.plugin.run.RunConfig;
import com.spacekiller.infection.plugin.run.RunConfigManager;
import com.spacekiller.infection.plugin.run.RunView;
import com.spacekiller.util.BeansToolkit;
import com.spacekiller.util.Platform;
import com.spacekiller.util.PreferencesRegistry;
import com.spacekiller.util.tooling.TAction;
import com.spacekiller.util.tooling.TMenu;
import com.spacekiller.util.tooling.TSeparator;
import com.spacekiller.util.tooling.Tool;
import com.spacekiller.util.workbench.View;
import com.spacekiller.util.workbench.Workbench;
import com.spacekiller.util.workbench.WorkbenchAction;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Comparator;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class RunMenu
extends TMenu {
    private RunConfigManager runConfigManager;
    private ActionHandler actionHandler = new ActionHandler();
    private static final Logger logger = Logger.getLogger(RunMenu.class.getName());

    public RunMenu() {
        this.initRunMenu();
    }

    protected void initRunMenu() {
        this.refreshRunMenu();
    }

    protected void run(Runnable runnable) {
        try {
            logger.fine("Run: " + runnable);
            if (runnable instanceof RunConfig) {
                RunConfig config = (RunConfig)runnable;
                config.setLastRunTime(System.currentTimeMillis());
                this.refreshRunMenu();
            }
            new Thread(runnable).start();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    protected void openRunMainView(Workbench wb) {
        RunView view = new RunView();
        view.setTitle("Run");
        try {
            view.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/com/spacekiller/infection/plugin/icons/run_exc.gif")));
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        BeansToolkit btk = wb.getBeansToolkit();
        if (btk != null) {
            view.setBeansToolkit(btk);
            view.setClassRegistry(btk.getClassRegistry());
        }
        PreferencesRegistry prefRegistry = Platform.getInstance().getPreferencesRegistry();
        view.setPreferencesRegistry(prefRegistry);
        view.setRunConfigManager(this.getRunConfigManager());
        wb.getPerspective().addView((View)view);
    }

    public RunConfigManager getRunConfigManager() {
        return this.runConfigManager;
    }

    public void setRunConfigManager(RunConfigManager mgr) {
        if (this.runConfigManager == mgr) {
            return;
        }
        if (this.runConfigManager != null) {
            this.runConfigManager.removeActionListener(this.actionHandler);
        }
        this.runConfigManager = mgr;
        if (this.runConfigManager != null) {
            this.runConfigManager.addActionListener(this.actionHandler);
        }
        this.refreshRunMenu();
    }

    protected void refreshRunMenu() {
        TreeSet<RunConfig> set = new TreeSet<RunConfig>(new RunConfigComparator());
        logger.fine("RunConfigManager: " + this.runConfigManager);
        if (this.runConfigManager != null) {
            int num = this.runConfigManager.getRunConfigCount();
            for (int c = 0; c < num; ++c) {
                RunConfig config = this.runConfigManager.getRunConfigAt(c);
                if (config == null || config.getLastRunTime() == 0L) continue;
                set.add(config);
            }
        }
        this.removeAll();
        TSeparator sep01 = new TSeparator();
        sep01.setName("set01");
        sep01.setPriority(0.99);
        this.addChild((Tool)sep01);
        RunMainAction runMainAction = new RunMainAction();
        runMainAction.setName("RunMainAction");
        runMainAction.setText("Other...");
        runMainAction.setTooltip("Manage configurations...");
        runMainAction.setPriority(0.5);
        this.addChild((Tool)runMainAction);
        int prio = 100 + set.size();
        for (RunConfig config : set) {
            RunAction action = new RunAction(config);
            action.setText(String.valueOf(config.getTitle()));
            action.setTooltip(config.getTooltip());
            action.setPriority(prio);
            Icon icon = null;
            if (this.runConfigManager != null) {
                icon = this.runConfigManager.getRunConfigIcon(config);
            }
            action.setIcon(icon);
            this.addChild((Tool)action);
            --prio;
        }
    }

    protected class RunConfigComparator
    implements Comparator {
        protected RunConfigComparator() {
        }

        public int compare(Object a, Object b) {
            long tb;
            RunConfig ca = (RunConfig)a;
            RunConfig cb = (RunConfig)b;
            long ta = ca.getLastRunTime();
            if (ta == (tb = cb.getLastRunTime())) {
                return 0;
            }
            if (ta > tb) {
                return -1;
            }
            return 1;
        }
    }

    protected class ActionHandler
    implements ActionListener {
        protected ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RunMenu.this.refreshRunMenu();
        }
    }

    protected class RunMainAction
    extends WorkbenchAction {
        protected RunMainAction() {
        }

        public void invoke(Object instance) {
            Workbench wb = this.getWorkbench(instance);
            if (wb == null) {
                return;
            }
            RunMenu.this.openRunMainView(wb);
        }
    }

    protected class RunAction
    extends TAction {
        private Runnable runnable;

        public RunAction(Runnable runnable) {
            this.setRunnable(runnable);
        }

        public void invoke(Object instance) {
            RunMenu.this.run(this.runnable);
        }

        protected Runnable getRunnable() {
            return this.runnable;
        }

        protected void setRunnable(Runnable runnable) {
            this.runnable = runnable;
        }
    }
}

