/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.infection.plugin.run;

import com.spacekiller.infection.plugin.run.RunConfigManager;
import com.spacekiller.infection.plugin.run.RunPanel;
import com.spacekiller.util.BeansToolkit;
import com.spacekiller.util.ClassRegistry;
import com.spacekiller.util.PreferencesRegistry;
import com.spacekiller.util.beans.BeanObserver;
import com.spacekiller.util.workbench.Perspective;
import com.spacekiller.util.workbench.View;
import com.spacekiller.util.workbench.ViewFocusEvent;
import com.spacekiller.util.workbench.ViewFocusListener;
import java.awt.Component;
import java.awt.Dimension;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RunView
extends View {
    private BeansToolkit beansToolkit;
    private ClassRegistry classRegistry;
    private PreferencesRegistry preferencesRegistry;
    private RunConfigManager runConfigManager;
    private RunPanel panel;
    private Perspective perspective;
    private ViewFocusHandler viewFocusHandler = new ViewFocusHandler();
    private BeanObserver selectedBeanObserver;
    private static final Logger logger = Logger.getLogger(RunView.class.getName());

    protected Component createComponent() {
        return this.getPanel();
    }

    protected void installChildComponent(View child, Component childComponent) {
    }

    protected void uninstallChildComponent(View child, Component childComponent) {
    }

    protected RunPanel createPanel() {
        RunPanel cc = new RunPanel();
        cc.setBeansToolkit(this.beansToolkit);
        cc.setClassRegistry(this.classRegistry);
        cc.setPreferencesRegistry(this.preferencesRegistry);
        cc.setRunConfigManager(this.runConfigManager);
        cc.setPreferredSize(new Dimension(500, 400));
        return cc;
    }

    public BeansToolkit getBeansToolkit() {
        return this.beansToolkit;
    }

    public void setBeansToolkit(BeansToolkit beansToolkit) {
        this.beansToolkit = beansToolkit;
    }

    public ClassRegistry getClassRegistry() {
        return this.classRegistry;
    }

    public void setClassRegistry(ClassRegistry classRegistry) {
        this.classRegistry = classRegistry;
    }

    protected void handleException(Throwable e) {
        logger.log(Level.SEVERE, e.getMessage(), e);
    }

    protected void handleViewFocusChanged(ViewFocusEvent e) {
        View view = e.getView();
        if (view == null || view == this) {
            return;
        }
        if (view instanceof BeanObserver) {
            this.setSelectedBeanObserver((BeanObserver)view);
            return;
        }
    }

    public synchronized void close() {
        super.close();
        this.selectedBeanObserver = null;
    }

    protected synchronized void parentChanged(View oldParent, View newParent) {
        super.parentChanged(oldParent, newParent);
        Perspective newPers = this.getPerspective();
        if (newPers == this.perspective) {
            return;
        }
        if (this.perspective != null) {
            this.perspective.removeViewFocusListener((ViewFocusListener)this.viewFocusHandler);
        }
        this.perspective = newPers;
        if (this.perspective != null) {
            this.perspective.addViewFocusListener((ViewFocusListener)this.viewFocusHandler);
        }
    }

    public BeanObserver getSelectedBeanObserver() {
        return this.selectedBeanObserver;
    }

    public void setSelectedBeanObserver(BeanObserver selectedBeanObserver) {
        this.selectedBeanObserver = selectedBeanObserver;
    }

    public RunPanel getPanel() {
        if (this.panel == null) {
            this.setPanel(this.createPanel());
        }
        return this.panel;
    }

    public void setPanel(RunPanel panel) {
        this.panel = panel;
    }

    public PreferencesRegistry getPreferencesRegistry() {
        return this.preferencesRegistry;
    }

    public void setPreferencesRegistry(PreferencesRegistry preferencesRegistry) {
        this.preferencesRegistry = preferencesRegistry;
    }

    public RunConfigManager getRunConfigManager() {
        return this.runConfigManager;
    }

    public void setRunConfigManager(RunConfigManager runConfigManager) {
        this.runConfigManager = runConfigManager;
        if (this.panel != null) {
            this.panel.setRunConfigManager(runConfigManager);
        }
    }

    protected class ViewFocusHandler
    implements ViewFocusListener {
        protected ViewFocusHandler() {
        }

        public void viewFocusChanged(ViewFocusEvent e) {
            RunView.this.handleViewFocusChanged(e);
        }
    }
}

