/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.spacekiller.level;

import com.spacekiller.game2d.Actor;
import com.spacekiller.game2d.ImageRenderer;
import com.spacekiller.game2d.Renderer;
import com.spacekiller.game2d.ResourceRegistry;
import com.spacekiller.game2d.Surface;
import com.spacekiller.game2d.TileLoop;
import com.spacekiller.game2d.TileModel;
import com.spacekiller.game2d.TileView;
import com.spacekiller.game2d.TileViewScrollActor;
import com.spacekiller.game2d.View;
import com.spacekiller.game2d.sound.AudioBufferPool;
import com.spacekiller.game2d.sound.AudioSequence;
import com.spacekiller.game2d.sound.ListAudioSequence;
import com.spacekiller.game2d.sound.LoopAudioSequence;
import com.spacekiller.spacekiller.DefaultLevel;
import java.awt.Color;
import java.awt.DisplayMode;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.ImageCapabilities;
import java.awt.image.VolatileImage;
import java.util.List;

public class Level06
extends DefaultLevel {
    public static final String MATRIX_CHARS = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private VolatileImage backImage;
    private Color backColor;
    private int width;
    private int height;
    private Font font16;
    private BackThread[] backThreads;

    public Level06() {
        this.initMatrixLevel();
    }

    protected void initMatrixLevel() {
        this.setName("Matrix");
        this.setDesigner("Bene");
        this.setModelResource("/com/spacekiller/spacekiller/resources/models/level06_model.zip");
        this.setSourceDisplayMode(new DisplayMode(1280, 1024, 32, 75));
        this.setOrientation(2);
        this.setScrollSpeedX(0.0);
        this.setScrollSpeedY(-0.2);
    }

    protected Image createBackgroundImage() throws Exception {
        VolatileImage image;
        Surface surface = this.getSurface();
        int surfaceW = surface.getWidth();
        int surfaceH = surface.getHeight();
        GraphicsConfiguration gc = surface.getWindow().getGraphicsConfiguration();
        try {
            boolean accelerated = true;
            ImageCapabilities caps = new ImageCapabilities(accelerated);
            image = gc.createCompatibleVolatileImage(surfaceW, surfaceH, caps, 1);
        }
        catch (Throwable e) {
            image = gc.createCompatibleVolatileImage(surfaceW, surfaceH);
        }
        Graphics2D g = image.createGraphics();
        this.backColor = new Color(0.0f, 0.05f, 0.0f);
        g.setColor(this.backColor);
        g.fillRect(0, 0, surfaceW, surfaceH);
        this.backImage = image;
        this.width = surfaceW;
        this.height = surfaceH;
        System.out.println("BackImage=" + this.backImage);
        int num = (int)((double)this.width * 1.5);
        for (int c = 0; c < num; ++c) {
            Font font = new Font("Matrix Code Font", 0, 1 + c * 7 / num);
            FontMetrics fm = surface.getWindow().getFontMetrics(font);
            int x = (int)(Math.random() * (double)this.width);
            int y = (int)(Math.random() * (double)this.height);
            Color col = new Color(0.0f, 0.1f + (float)c * 0.6f / (float)num, 0.0f);
            double speed = 0.01;
            int len = 20 + (int)(Math.random() * 20.0);
            BackThread bt = new BackThread(fm, len, x, y, col, col, speed);
            bt.paint(g);
            if (y + len * fm.getHeight() <= surfaceH) continue;
            bt = new BackThread(fm, len, x, y -= surfaceH, col, col, speed);
            bt.paint(g);
        }
        g.dispose();
        return image;
    }

    protected View createBackgroundView() throws Exception {
        Surface surface = this.getSurface();
        int surfaceW = surface.getWidth();
        int surfaceH = surface.getHeight();
        Image backImage = this.createBackgroundImage();
        System.out.println("BackImage=" + backImage);
        backImage = this.makeBackgroundImage(backImage, surfaceW, surfaceH);
        ImageRenderer tile = new ImageRenderer(backImage);
        TileLoop tileLoop = new TileLoop((double)surfaceW, (double)surfaceH, 1, 1);
        tileLoop.setTile(0, 0, (Renderer)tile);
        TileView tileView = (TileView)tileLoop.createView(0.0, 0.0, (double)surfaceW, (double)surfaceH);
        tileView.setWidth(surfaceW);
        tileView.setHeight(surfaceH);
        double scrollX = 0.0;
        double scrollY = -((double)surfaceH) / 10000.0;
        TileViewScrollActor scrollActor = new TileViewScrollActor((TileModel)tileLoop, tileView, scrollX, scrollY);
        this.addActor((Actor)scrollActor);
        return tileView;
    }

    protected AudioSequence createAudioSequence(AudioBufferPool pool) throws Exception {
        ResourceRegistry reg = this.getRegistry();
        AudioSequence seq1 = reg.getAudioSequence("matrix_intro.wav");
        AudioSequence seq2 = reg.getAudioSequence("sk102_matrix03a.wav");
        AudioSequence seq3 = reg.getAudioSequence("sk102_matrix03b.wav");
        AudioSequence seq4 = reg.getAudioSequence("sk125_matrix01a.wav");
        AudioSequence seq5 = reg.getAudioSequence("sk125_matrix01b.wav");
        AudioSequence seq6 = reg.getAudioSequence("sk125_matrix01c.wav");
        AudioSequence seq7 = reg.getAudioSequence("sk125_matrix01d.wav");
        AudioSequence seq2a = reg.getAudioSequence("sk125_matrix02a.wav");
        AudioSequence seq2b = reg.getAudioSequence("sk125_matrix02b.wav");
        AudioSequence seq2c = reg.getAudioSequence("sk125_matrix02c.wav");
        AudioSequence seq2d = reg.getAudioSequence("sk125_matrix02d.wav");
        AudioSequence seq2e = reg.getAudioSequence("sk125_matrix02e.wav");
        LoopAudioSequence loop2 = new LoopAudioSequence(seq2, 4);
        LoopAudioSequence loop3 = new LoopAudioSequence(seq3, 4);
        LoopAudioSequence loop5 = new LoopAudioSequence(seq5, 4);
        LoopAudioSequence loop6 = new LoopAudioSequence(seq6, 4);
        LoopAudioSequence loop7 = new LoopAudioSequence(seq7, 4);
        ListAudioSequence list2bc = new ListAudioSequence();
        list2bc.addAudioSequence(seq2b);
        list2bc.addAudioSequence(seq2b);
        list2bc.addAudioSequence(seq2c);
        list2bc.addAudioSequence(seq2c);
        LoopAudioSequence loop2bc = new LoopAudioSequence((AudioSequence)list2bc, 32);
        ListAudioSequence song = new ListAudioSequence();
        song.addAudioSequence(seq1);
        song.addAudioSequence((AudioSequence)loop2);
        song.addAudioSequence((AudioSequence)loop3);
        song.addAudioSequence(seq4);
        song.addAudioSequence((AudioSequence)loop5);
        song.addAudioSequence((AudioSequence)loop6);
        song.addAudioSequence((AudioSequence)loop7);
        song.addAudioSequence(seq2a);
        song.addAudioSequence(seq2a);
        song.addAudioSequence(seq2e);
        song.addAudioSequence((AudioSequence)loop2bc);
        song.addAudioSequence(seq2d);
        LoopAudioSequence loop = new LoopAudioSequence((AudioSequence)song, -1);
        return loop;
    }

    protected void initializeShipGadgets(List ships) throws Exception {
        super.initializeShipGadgets(ships);
        this.installShipGadget("gadgetType_Weapon01", 5, ships);
        this.installShipGadget("gadgetType_Weapon02", 5, ships);
        this.installShipGadget("gadgetType_Weapon03", 1, ships);
        this.installShipGadget("gadgetType_Weapon04", 2, ships);
        this.installShipGadget("gadgetType_Weapon05", 5, ships);
        this.installShipGadget("gadgetType_Weapon10", 2, ships);
        this.installShipGadget("gadgetType_Score1000", 5, ships);
        this.installShipGadget("gadgetType_Shield100", 10, ships);
        this.installShipGadget("gadgetType_Live", 1, ships);
    }

    protected void initializeSpaceViews(List actorList) throws Exception {
        this.initializeMatrixBackground(actorList);
    }

    protected void initializeMatrixBackground(List actorList) throws Exception {
        actorList.add(new MatrixBackgroundActor());
    }

    public static char randomChar() {
        return MATRIX_CHARS.charAt((int)(Math.random() * (double)MATRIX_CHARS.length()));
    }

    protected class BackThread {
        private Font font;
        private int fontHeight;
        public char[] chars;
        private int pos;
        public Color[] colors;
        public int len;
        private int x;
        private int y;
        private int width;
        private int height;
        private double yDelta;
        private double speed;

        public BackThread(FontMetrics font, int len, int x, int y, Color color, Color leadColor, double speed) {
            this.len = len;
            this.chars = new char[len];
            this.colors = new Color[len];
            for (int c = 0; c < len; ++c) {
                this.chars[c] = Level06.randomChar();
                this.colors[c] = new Color(color.getRed() * c / len, color.getGreen() * c / len, color.getBlue() * c / len);
            }
            this.colors[len - 1] = leadColor;
            this.font = font.getFont();
            this.x = x;
            this.y = y;
            this.width = font.stringWidth("Z");
            this.height = font.getHeight() * len;
            this.fontHeight = font.getHeight();
            this.speed = speed;
        }

        public void paint(Graphics g) {
            g.setFont(this.font);
            for (int c = 0; c < this.len; ++c) {
                this.paintCharAt(c, g);
            }
        }

        public void paintCharAt(int i, Graphics g) {
            g.setColor(this.colors[i]);
            g.drawChars(this.chars, (this.pos + i) % this.len, 1, this.x, this.y + i * this.fontHeight);
        }

        public void drawCharAt(int i, Graphics g) {
            g.drawChars(this.chars, (this.pos + i) % this.len, 1, this.x, this.y + i * this.fontHeight);
        }

        public void move(long ms) {
            this.yDelta += (double)ms * this.speed;
        }

        public void swap() {
            ++this.pos;
            this.setCharAt(this.len - 1, Level06.randomChar());
            this.y += this.fontHeight;
        }

        public char charAt(int i) {
            return this.chars[(this.pos + i) % this.len];
        }

        public void setCharAt(int i, char ch) {
            this.chars[(this.pos + i) % this.len] = ch;
        }
    }

    protected class MatrixBackgroundActor
    extends Actor {
        protected MatrixBackgroundActor() {
        }

        public void invoke(long ms) {
            if (ms < 1L) {
                return;
            }
        }
    }
}

