/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.spacekiller.level;

import com.spacekiller.game2d.ElementModel;
import com.spacekiller.game2d.ElementView;
import com.spacekiller.game2d.ElementViewScrollActor;
import com.spacekiller.game2d.ResourceRegistry;
import com.spacekiller.game2d.Surface;
import com.spacekiller.game2d.View;
import com.spacekiller.game2d.sound.AudioBufferPool;
import com.spacekiller.game2d.sound.AudioSequence;
import com.spacekiller.game2d.sound.ListAudioSequence;
import com.spacekiller.game2d.sound.LoopAudioSequence;
import com.spacekiller.spacekiller.DefaultLevel;
import com.spacekiller.spacekiller.SpeedListener;
import java.awt.DisplayMode;
import java.awt.Image;
import java.util.List;

public class Level10
extends DefaultLevel {
    public Level10() {
        this.initLevel10();
    }

    protected void initLevel10() {
        this.setName("Last");
        this.setDesigner("Bene");
        this.setModelResource("/com/spacekiller/spacekiller/resources/models/level10_model.zip");
        this.setSourceDisplayMode(new DisplayMode(1280, 1024, 32, 75));
    }

    protected Image createBackgroundImage() throws Exception {
        return this.loadImage(((Object)((Object)this)).getClass().getResource("/com/spacekiller/spacekiller/resources/images/pleiades_gendler.jpg"));
    }

    protected AudioSequence createAudioSequence(AudioBufferPool pool) throws Exception {
        ResourceRegistry reg = this.getRegistry();
        AudioSequence seq01a = reg.getAudioSequence("sk173_beasty01a.wav");
        AudioSequence seq01b = reg.getAudioSequence("sk173_beasty01b.wav");
        AudioSequence seq01c = reg.getAudioSequence("sk173_beasty01c.wav");
        AudioSequence seq01d = reg.getAudioSequence("sk173_beasty01d.wav");
        AudioSequence seq01e = reg.getAudioSequence("sk173_beasty01e.wav");
        AudioSequence seq01f = reg.getAudioSequence("sk173_beasty01f.wav");
        AudioSequence seq01g = reg.getAudioSequence("sk173_beasty01g.wav");
        ListAudioSequence song = new ListAudioSequence();
        song.addAudioSequence(seq01b);
        song.addAudioSequence(seq01c);
        song.addAudioSequence(seq01d);
        song.addAudioSequence(seq01e);
        song.addAudioSequence(seq01f);
        song.addAudioSequence(seq01f);
        song.addAudioSequence(seq01g);
        song.addAudioSequence(seq01a);
        song.addAudioSequence(seq01a);
        LoopAudioSequence loop = new LoopAudioSequence((AudioSequence)song, -1);
        return loop;
    }

    protected void initializeShipGadgets(List ships) throws Exception {
        super.initializeShipGadgets(ships);
        this.installShipGadget("gadgetType_Weapon01", 1, ships);
        this.installShipGadget("gadgetType_Weapon02", 5, ships);
        this.installShipGadget("gadgetType_Weapon04", 5, ships);
        this.installShipGadget("gadgetType_Weapon05", 3, ships);
        this.installShipGadget("gadgetType_Weapon10", 2, ships);
        this.installShipGadget("gadgetType_Weapon11", 5, ships);
        this.installShipGadget("gadgetType_Weapon08", 5, ships);
        this.installShipGadget("gadgetType_Score1000", 5, ships);
        this.installShipGadget("gadgetType_Shield100", 10, ships);
    }

    protected void initializeSpaceViews(List actorList) throws Exception {
        this.initializeScrollViews(actorList);
    }

    protected void initializeScrollViews(List actorList) throws Exception {
        Surface surface = this.getSurface();
        int surfaceW = surface.getWidth();
        int surfaceH = surface.getHeight();
        double scrollSpeedX = 1.0;
        double scrollSpeedX2 = scrollSpeedX / 2.0;
        double scrollSpeedX4 = scrollSpeedX / 4.0;
        String modelResourceC = "/com/spacekiller/spacekiller/resources/models/paralax02c.zip";
        ElementModel modelC = this.readModel(((Object)((Object)this)).getClass().getResource(modelResourceC));
        ElementView viewC = (ElementView)modelC.createView(0.0, 0.0, (double)surfaceW, (double)surfaceH);
        viewC.setX(0);
        viewC.setY(surfaceH - 100);
        viewC.setWidth(surfaceW);
        viewC.setHeight(surfaceH);
        surface.addView((View)viewC);
        this.initScrollView(modelC, viewC, actorList, scrollSpeedX4);
        String modelResourceE = "/com/spacekiller/spacekiller/resources/models/paralax02b.zip";
        ElementModel modelE = this.readModel(((Object)((Object)this)).getClass().getResource(modelResourceE));
        ElementView viewE = (ElementView)modelE.createView(0.0, 0.0, (double)surfaceW, (double)surfaceH);
        viewE.setX(0);
        viewE.setY(surfaceH - 83);
        viewE.setWidth(surfaceW);
        viewE.setHeight(surfaceH);
        surface.addView((View)viewE);
        this.initScrollView(modelE, viewE, actorList, scrollSpeedX2);
    }

    private void initScrollView(ElementModel model, ElementView view, List actorList, double speedFactor) {
        ElementViewScrollActor scrollActor = new ElementViewScrollActor(model, view, 0.0, 0.0);
        actorList.add(0, scrollActor);
        DefaultLevel.ElementViewScrollHandler scrollHandler = new DefaultLevel.ElementViewScrollHandler(scrollActor, speedFactor);
        this.addScrollSpeedListener((SpeedListener)scrollHandler);
        scrollHandler.speedChanged(this.getScrollSpeedX(), this.getScrollSpeedY());
    }
}

