/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.spacekiller.level.intro;

import com.spacekiller.game2d.Actor;
import com.spacekiller.game2d.ActorSequence;
import com.spacekiller.game2d.EndOfSceneActor;
import com.spacekiller.game2d.ImageScaleActor;
import com.spacekiller.game2d.ImageScaleView;
import com.spacekiller.game2d.ResourceRegistry;
import com.spacekiller.game2d.SleepActor;
import com.spacekiller.game2d.Speed2D;
import com.spacekiller.game2d.Surface;
import com.spacekiller.game2d.View;
import com.spacekiller.game2d.sound.AudioBufferPool;
import com.spacekiller.game2d.sound.AudioSequence;
import com.spacekiller.game2d.sound.ListAudioSequence;
import com.spacekiller.game2d.sound.LoopAudioSequence;
import com.spacekiller.spacekiller.DefaultLevel;
import com.spacekiller.spacekiller.SpaceKillerConstants;
import com.spacekiller.spacekiller.level.intro.StarFontView;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Image;
import java.awt.Rectangle;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class IntroLevel
extends DefaultLevel
implements SpaceKillerConstants {
    public IntroLevel() {
        this.initIntroLevel();
    }

    public boolean isIntroLevel() {
        return true;
    }

    private void initIntroLevel() {
        this.setModelResource("/com/spacekiller/spacekiller/resources/models/model2.zip");
        this.setScrollSpeed((Speed2D)new Speed2D.Double(0.0, 0.0));
    }

    protected Image createBackgroundImage() throws Exception {
        return this.getRegistry().getImage("image.spacekiller.intro.back");
    }

    protected void initializeSpaceViews(List actorList) throws Exception {
    }

    public void initialize() throws Exception {
        super.initialize();
        ActorSequence sequence = new ActorSequence();
        this.addActor((Actor)sequence);
        this.initSpaceKillerIntro_LogoZoom(sequence);
        this.initSpaceKillerIntro_TextScroll(sequence);
        sequence.add((Actor)new EndOfSceneActor("Intro completed."));
    }

    protected void initSpaceKillerIntro_LogoZoom(ActorSequence sequence) throws Exception {
        Surface surface = this.getSurface();
        int surfaceWidth = surface.getWidth();
        int surfaceHeight = surface.getHeight();
        Image image = this.getRegistry().getImage("image.spacekiller.logo.starfont");
        int imageWidth = image.getWidth(null);
        int imageHeight = image.getHeight(null);
        double iwh = (double)imageHeight / (double)imageWidth;
        ImageScaleView imageScaleView = new ImageScaleView(surfaceWidth, surfaceHeight, image);
        int startWidth = surfaceWidth * 2;
        int startHeight = (int)((double)startWidth * iwh);
        int endWidth = surfaceWidth / 2;
        int endHeight = (int)((double)endWidth * iwh);
        Rectangle startBounds = new Rectangle(surfaceWidth / 2 - startWidth / 2, surfaceHeight / 2 - startHeight / 2, startWidth, startHeight);
        Rectangle endBounds = new Rectangle(surfaceWidth / 2 - endWidth / 2, surfaceHeight / 2 - endHeight / 2, endWidth, endHeight);
        imageScaleView.setImageBounds(startBounds);
        long millis = 2000L;
        ImageScaleActor scaleActor1 = new ImageScaleActor(imageScaleView, startBounds, endBounds, millis);
        startWidth = endWidth;
        startHeight = endHeight;
        endWidth = 0;
        endHeight = 0;
        startBounds = new Rectangle(surfaceWidth / 2 - startWidth / 2, surfaceHeight / 2 - startHeight / 2, startWidth, startHeight);
        endBounds = new Rectangle(surfaceWidth / 2 - endWidth / 2, surfaceHeight / 2 - endHeight / 2, endWidth, endHeight);
        millis = 1500L;
        ImageScaleActor scaleActor2 = new ImageScaleActor(imageScaleView, startBounds, endBounds, millis);
        surface.addView((View)imageScaleView);
        sequence.add((Actor)scaleActor1);
        sequence.add((Actor)new SleepActor(10000L));
        sequence.add((Actor)scaleActor2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initSpaceKillerIntro_TextScroll(ActorSequence sequence) throws Exception {
        ArrayList<String> introText = new ArrayList<String>();
        String resource = "/com/spacekiller/spacekiller/resources/text/spacekiller_intro.txt";
        try {
            URL url = ((Object)((Object)this)).getClass().getResource(resource);
            if (url == null) {
                throw new Error("Intro text not found: " + resource);
            }
            String playerName = System.getProperty("user.name");
            if (playerName == null) {
                playerName = "you";
            }
            HashMap<String, String> vars = new HashMap<String, String>();
            vars.put("player.name", playerName.toUpperCase());
            InputStream in = url.openStream();
            try {
                String s;
                BufferedReader reader = new BufferedReader(new InputStreamReader(in));
                while ((s = reader.readLine()) != null) {
                    s = this.resolveVariables(s, vars);
                    introText.add(s);
                }
            }
            finally {
                in.close();
            }
        }
        catch (Exception e) {
            throw new Error(e);
        }
        Surface surface = this.getSurface();
        int surfaceWidth = surface.getWidth();
        int surfaceHeight = surface.getHeight();
        StarFontView starFontView = new StarFontView(surfaceWidth, surfaceHeight);
        Color color = new Color(255, 223, 0);
        double scaleX = 0.5;
        double scaleY = 0.5;
        starFontView.setDistancePerMillis(4.0E-5);
        starFontView.setColorCount(31);
        Font font = new Font("dialog", 1, 80);
        FontMetrics metrics = surface.getFontMetrics(font);
        for (String text : introText) {
            starFontView.addTextLine(text, color, metrics, scaleX, scaleY);
        }
        surface.addView((View)starFontView);
        Actor startActor = starFontView.getStartActor();
        sequence.add(startActor);
        Actor updateActor = starFontView.getUpdateActor();
        sequence.add(updateActor);
    }

    private String resolveVariables(String string, Map variables) {
        int y;
        int x;
        int from = 0;
        while (from < string.length() && (x = string.indexOf("${", from)) >= 0 && (y = string.indexOf("}", x)) >= 0) {
            String key = string.substring(x + 2, y);
            String value = (String)variables.get(key);
            if (value != null) {
                string = string.substring(0, x) + value + string.substring(y + 1);
                from = x + value.length();
                continue;
            }
            from = y + 1;
        }
        return string;
    }

    protected AudioSequence createAudioSequence(AudioBufferPool pool) throws Exception {
        ResourceRegistry reg = this.getRegistry();
        AudioSequence seq_mike = reg.getAudioSequence("skintro_mike.wav");
        AudioSequence seq_cybertek01 = reg.getAudioSequence("skintro_cybertek01.wav");
        AudioSequence seq_cybertek02 = reg.getAudioSequence("skintro_cybertek02.wav");
        ListAudioSequence list_cybertek = new ListAudioSequence();
        list_cybertek.addAudioSequence(seq_cybertek01);
        list_cybertek.addAudioSequence(seq_cybertek02);
        LoopAudioSequence loop_cybertek = new LoopAudioSequence((AudioSequence)list_cybertek, -1);
        ListAudioSequence song = new ListAudioSequence();
        song.addAudioSequence(seq_mike);
        song.addAudioSequence((AudioSequence)loop_cybertek);
        return song;
    }
}

