/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.spacekiller.level.intro;

import com.spacekiller.game2d.AbstractView;
import com.spacekiller.game2d.Actor;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public class StarFontView
extends AbstractView {
    private double distancePerMillis = 2.0E-5;
    private int colorCount = 30;
    private List textList;
    private List lines;
    private StartActor startActor = new StartActor();
    private StarFontActor starFontActor = new StarFontActor();
    private AsyncWorker asyncWorker;

    public StarFontView(int width, int height) {
        this.setWidth(width);
        this.setHeight(height);
        this.initStarFontView();
    }

    protected void initStarFontView() {
        this.textList = new ArrayList();
        this.lines = new ArrayList();
        this.asyncWorker = new AsyncWorker();
    }

    public void paint(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        try {
            int n = this.lines.size();
            for (int i = 0; i < n; ++i) {
                StarFontLine line = (StarFontLine)this.lines.get(i);
                double dist = line.distance;
                if (!(dist >= 0.0) || !(dist <= 1.0)) continue;
                line.draw(g2d);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    protected void start() {
        this.reset();
        this.asyncWorker = new AsyncWorker();
        this.asyncWorker.start();
    }

    protected void stop() {
        this.asyncWorker.stop();
        this.starFontActor.dispose();
    }

    public void reset() {
        int width = this.getWidth();
        int height = this.getHeight();
        this.lines.clear();
        int index = 0;
        for (StarFontText textLine : this.textList) {
            char[] chars = textLine.chars;
            Color color = textLine.color;
            FontMetrics metrics = textLine.fontMetrics;
            double scaleX = textLine.scaleX;
            double scaleY = textLine.scaleY;
            int startX = width / 2;
            int startY = height + metrics.getHeight();
            int endX = startX;
            int endY = height / 2;
            double shearMax = 0.5;
            double shearMin = -shearMax;
            double minusDistance = (double)index * 0.05;
            StarFontLine line = new StarFontLine(chars, startX, startY, endX, endY, scaleX, scaleY, color, this.colorCount, metrics, width, height, shearMin, shearMax);
            line.setDistance(0.0 - minusDistance);
            this.lines.add(line);
            ++index;
        }
    }

    protected void action(long ms) {
        if (ms <= 0L) {
            return;
        }
        int n = this.lines.size();
        for (int i = 0; i < n; ++i) {
            StarFontLine line = (StarFontLine)this.lines.get(i);
            double dist = line.distance + (double)ms * this.distancePerMillis;
            if (dist < 0.0) {
                line.distance = dist;
                continue;
            }
            if (dist > 1.0) {
                this.lines.remove(i);
                --i;
                --n;
                continue;
            }
            line.setDistance(dist);
        }
        if (this.lines.isEmpty()) {
            System.out.println("TODO: No more lines. stop!");
            this.stop();
        }
    }

    public void addTextLine(String text, Color color, FontMetrics metrics, double scaleX, double scaleY) {
        char[] chars = text.toCharArray();
        StarFontText textLine = new StarFontText(chars, color, metrics, scaleX, scaleY);
        this.textList.add(textLine);
    }

    public int getLineCount() {
        return this.lines.size();
    }

    public void removeLineAt(int index) {
        this.lines.remove(index);
    }

    public void removeAllLines() {
        this.lines.clear();
    }

    protected void invokeAsync(Runnable runnable) {
        this.asyncWorker.add(runnable);
    }

    public Actor getStartActor() {
        return this.startActor;
    }

    public Actor getUpdateActor() {
        return this.starFontActor;
    }

    public double getDistancePerMillis() {
        return this.distancePerMillis;
    }

    public void setDistancePerMillis(double distancePerMillis) {
        this.distancePerMillis = distancePerMillis;
    }

    public int getColorCount() {
        return this.colorCount;
    }

    public void setColorCount(int colorCount) {
        this.colorCount = colorCount;
    }

    protected class AsyncWorker
    implements Runnable {
        private LinkedList work = new LinkedList();
        private boolean cancel = false;

        protected AsyncWorker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.cancel = false;
            while (!this.cancel) {
                Runnable r;
                while (true) {
                    AsyncWorker asyncWorker = this;
                    synchronized (asyncWorker) {
                        if (this.work.isEmpty()) {
                            break;
                        }
                        r = (Runnable)this.work.removeFirst();
                    }
                    r.run();
                }
                try {
                    r = this;
                    synchronized (r) {
                        if (this.work.isEmpty()) {
                            this.wait();
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }

        public synchronized void add(Runnable r) {
            boolean wake = this.work.isEmpty();
            this.work.add(r);
            if (wake) {
                this.notify();
            }
        }

        public void start() {
            new Thread(this).start();
        }

        public void stop() {
            this.cancel = true;
        }
    }

    protected class StarFontLine {
        private char[] chars;
        private int len;
        private int charsWidth;
        private int charsHeight;
        private int[] charWidths;
        private double[] shx;
        private double shy;
        private Font font;
        private FontMetrics metrics;
        private Color color;
        private int colorCount;
        private Color[] colors;
        private double shearMin;
        private double shearMax;
        private double startX;
        private double startY;
        private double endX;
        private double endY;
        private double startWidth;
        private double startHeight;
        private double scaledWidth;
        private double scaledHeight;
        private double distance;
        private double x;
        private double y;
        private double width;
        private double height;
        private Image image;
        private int imageColorIndex;

        public StarFontLine(char[] chars, double startX, double startY, double endX, double endY, double scaleX, double scaleY, Color color, int colorCount, FontMetrics metrics, int viewWidth, int viewHeight, double shearMin, double shearMax) {
            this.chars = chars;
            this.len = chars.length;
            this.metrics = metrics;
            this.font = metrics.getFont();
            this.shearMin = shearMin;
            this.shearMax = shearMax;
            this.charWidths = new int[this.len];
            this.shx = new double[this.len];
            this.charsWidth = 0;
            this.charsHeight = metrics.getHeight();
            for (int i = 0; i < this.len; ++i) {
                int k;
                this.charWidths[i] = k = metrics.charWidth(chars[i]);
                this.charsWidth += k;
            }
            if (this.charsWidth < 1) {
                this.charsWidth = 1;
            }
            this.startX = startX;
            this.startY = startY;
            this.endX = endX;
            this.endY = endY;
            this.color = color;
            this.colorCount = colorCount;
            AffineTransform trans = new AffineTransform();
            trans.setToTranslation(startX, startY);
            this.x = startX;
            this.y = startY;
            float[] startRGBA = color.getRGBComponents(new float[4]);
            float[] endRGBA = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
            this.colors = new Color[colorCount];
            for (int i = 0; i < this.colors.length; ++i) {
                float q = (float)(this.colors.length - i) / (float)this.colors.length;
                q = 1.0f - q;
                float r = startRGBA[0] + (endRGBA[0] - startRGBA[0]) * q;
                float g = startRGBA[1] + (endRGBA[1] - startRGBA[1]) * q;
                float b = startRGBA[2] + (endRGBA[2] - startRGBA[2]) * q;
                float a = startRGBA[3] + (endRGBA[3] - startRGBA[3]) * q;
                this.colors[i] = new Color(r, g, b, a);
            }
            this.computeShear(viewWidth, viewHeight, shearMin, shearMax);
            this.startWidth = (double)this.charsWidth + (double)this.charsHeight * shearMax * 4.0;
            this.startHeight = this.charsHeight;
            this.image = this.createImage(this.colors[0]);
            this.scaledWidth = this.startWidth * scaleX;
            this.scaledHeight = this.startHeight * scaleY;
            this.width = this.scaledWidth;
            this.height = this.scaledHeight;
        }

        public void draw(Graphics2D g) {
            int dw = (int)this.width / 2 * 2;
            int dh = (int)this.height / 2 * 2;
            int dx = (int)this.x - dw / 2;
            int dy = (int)this.y - dh / 2;
            g.drawImage(this.image, dx, dy, dw, dh, null);
        }

        private Image createImage(Color col) {
            int imgWidth = (int)Math.round(this.startWidth);
            int imgHeight = (int)Math.round(this.startHeight);
            BufferedImage bi = new BufferedImage(imgWidth, imgHeight, 2);
            Graphics2D g2d = bi.createGraphics();
            HashMap<RenderingHints.Key, Object> rh = new HashMap<RenderingHints.Key, Object>();
            rh.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.setRenderingHints(new RenderingHints(rh));
            g2d.setFont(this.font);
            g2d.setColor(col);
            int cx = (int)((double)this.charsHeight * this.shearMax * 2.0);
            int cy = this.metrics.getAscent();
            for (int i = 0; i < this.len; ++i) {
                g2d.shear(this.shx[i], this.shy);
                g2d.drawChars(this.chars, i, 1, cx, cy);
                cx += this.charWidths[i];
            }
            g2d.dispose();
            return bi;
        }

        private void computeShear(int width, int height, double shearMin, double shearMax) {
            if (this.len < 1) {
                return;
            }
            double shearStart = shearMin * (double)this.charsWidth / (double)width;
            double shearEnd = shearMax * (double)this.charsWidth / (double)width;
            int pos = 0;
            double prevShear = 0.0;
            for (int i = 0; i < this.len; ++i) {
                double newShear = (shearEnd - shearStart) * (double)pos / (double)this.charsWidth;
                this.shx[i] = newShear - prevShear;
                prevShear = newShear;
                pos += this.charWidths[i];
            }
            this.shx[0] = shearStart;
            this.shy = 0.0;
        }

        public double getDistance() {
            return this.distance;
        }

        public void setDistance(double newDistance) {
            if (this.distance == newDistance) {
                return;
            }
            this.distance = newDistance;
            if (newDistance < 0.0) {
                return;
            }
            double q = 1.0 - newDistance;
            q = 1.0 - q * q;
            this.x = this.startX + (this.endX - this.startX) * q;
            this.y = this.startY + (this.endY - this.startY) * q;
            double v = 1.0 - this.distance;
            this.width = this.scaledWidth * v;
            this.height = this.scaledHeight * v;
            int colorIndex = (int)(newDistance * (double)this.colorCount);
            if (colorIndex < 0) {
                colorIndex = 0;
            } else if (colorIndex >= this.colorCount) {
                colorIndex = this.colorCount - 1;
            }
            if (colorIndex != this.imageColorIndex) {
                this.imageColorIndex = colorIndex;
                final Color col = this.colors[colorIndex];
                StarFontView.this.invokeAsync(new Runnable(){

                    @Override
                    public void run() {
                        StarFontLine.this.image = StarFontLine.this.createImage(col);
                    }
                });
            }
        }
    }

    protected static class StarFontText {
        private char[] chars;
        private Color color;
        private FontMetrics fontMetrics;
        private double scaleX;
        private double scaleY;

        public StarFontText(char[] chars, Color color, FontMetrics fontMetrics, double scaleX, double scaleY) {
            this.chars = chars;
            this.color = color;
            this.fontMetrics = fontMetrics;
            this.scaleX = scaleX;
            this.scaleY = scaleY;
        }
    }

    protected class StarFontActor
    extends Actor {
        protected StarFontActor() {
        }

        public void invoke(long ms) {
            StarFontView.this.action(ms);
        }

        protected void dispose() {
            super.dispose();
        }
    }

    protected class StartActor
    extends Actor {
        protected StartActor() {
        }

        public void invoke(long ms) {
            StarFontView.this.start();
            this.dispose();
        }
    }
}

