/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.spacekiller.level.matrix;

import com.spacekiller.game2d.BehaviorType;
import com.spacekiller.game2d.CollisionBounds;
import com.spacekiller.game2d.CollisionGroup;
import com.spacekiller.game2d.ElementType;
import com.spacekiller.game2d.ResourceType;
import com.spacekiller.game2d.resource.AbstractElementTypeResource;
import com.spacekiller.game2d.resource.BehaviorTypeResource;
import com.spacekiller.spacekiller.level.matrix.MatrixAsteroidTypeResourceType;
import com.spacekiller.spacekiller.level.matrix.MatrixThreadRenderer;
import com.spacekiller.spacekiller.level.matrix.MatrixThreadType;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Rectangle;

public class MatrixAsteroidElementTypeResource
extends AbstractElementTypeResource {
    private double power;
    private BehaviorTypeResource behaviorTypeResource;
    private Font font;
    private int fontWidth;
    private int fontHeight;
    private int charCount = 15;
    private volatile transient MatrixThreadType matrixThreadType;

    public MatrixAsteroidElementTypeResource(String id, double power, BehaviorTypeResource behaviorTypeResource, FontMetrics fm) {
        super(id, (ResourceType)MatrixAsteroidTypeResourceType.getMatrixAsteroidTypeResourceType());
        this.power = power;
        this.behaviorTypeResource = behaviorTypeResource;
        this.font = fm.getFont();
        this.fontWidth = fm.stringWidth("Z");
        this.fontHeight = fm.getHeight();
    }

    protected ElementType createElementType() throws Exception {
        return this.getMatrixThreadType();
    }

    public MatrixThreadType getMatrixThreadType() throws Exception {
        if (this.matrixThreadType == null) {
            this.setMatrixThreadType(this.createMatrixThreadType());
        }
        return this.matrixThreadType;
    }

    protected void setMatrixThreadType(MatrixThreadType matrixThreadType) {
        this.matrixThreadType = matrixThreadType;
    }

    protected MatrixThreadType createMatrixThreadType() throws Exception {
        MatrixThreadRenderer renderer = new MatrixThreadRenderer();
        BehaviorType behaviorType = this.behaviorTypeResource == null ? null : this.behaviorTypeResource.getBehaviorType();
        int width = this.fontWidth;
        int height = this.fontHeight * this.charCount;
        Rectangle rect = new Rectangle(width, height);
        CollisionBounds bounds = new CollisionBounds(rect, new Rectangle[]{rect});
        CollisionGroup cgroup = null;
        Color color = Color.green;
        Color leadColor = new Color(0.7f, 1.0f, 0.7f);
        MatrixThreadType type = new MatrixThreadType(this.getId(), renderer, width, height, bounds, cgroup, this.font, this.fontHeight, 15, color, leadColor);
        type.setPower(this.power);
        type.setBehaviorType(behaviorType);
        return type;
    }

    public void flush() throws Exception {
        this.setMatrixThreadType(null);
    }
}

