/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.spacekiller.level.matrix;

import com.spacekiller.game2d.ElementType;
import com.spacekiller.game2d.Renderer;
import com.spacekiller.spacekiller.Asteroid;
import com.spacekiller.spacekiller.level.Level06;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;

public class MatrixThread
extends Asteroid {
    protected Font font;
    protected int fontHeight;
    protected char[] chars;
    protected int pos;
    protected int len;
    protected Color[] colors;

    public MatrixThread(Object id, double x, double y, double w, double h, ElementType t, Renderer r, int charCount, Color[] colors, Font font, int fontHeight) {
        super(id, x, y, w, h, t, r);
        this.font = font;
        this.fontHeight = fontHeight;
        this.len = charCount;
        this.chars = new char[this.len];
        this.colors = colors;
        for (int c = 0; c < this.len; ++c) {
            this.chars[c] = Level06.randomChar();
        }
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public int getFontHeight() {
        return this.fontHeight;
    }

    public void setFontHeight(int fontHeight) {
        this.fontHeight = fontHeight;
    }

    public void paint(Graphics g) {
        g.setFont(this.font);
        int y = this.fontHeight;
        for (int c = 0; c < this.len; ++c) {
            g.setColor(this.colors[c]);
            g.drawChars(this.chars, (this.pos + c) % this.len, 1, 0, y);
            y += this.fontHeight;
        }
    }

    public void swap() {
        ++this.pos;
        this.chars[(this.pos + this.len - 1) % this.len] = Level06.randomChar();
    }

    public void updateChars() {
        int i = (this.pos + this.len - 1) % this.len;
        this.chars[i] = Level06.randomChar();
        i = (this.pos + (int)(Math.random() * (double)(this.len - 1))) % this.len;
        this.chars[i] = Level06.randomChar();
    }
}

