/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.spacekiller.level.matrix;

import com.spacekiller.game2d.CollisionBounds;
import com.spacekiller.game2d.CollisionGroup;
import com.spacekiller.game2d.Element;
import com.spacekiller.game2d.ElementType;
import com.spacekiller.game2d.Renderer;
import com.spacekiller.spacekiller.AsteroidType;
import com.spacekiller.spacekiller.level.matrix.MatrixThread;
import java.awt.Color;
import java.awt.Font;

public class MatrixThreadType
extends AsteroidType {
    private int charCount = 15;
    private Color[] colors;
    private Font font;
    private int fontHeight;

    public MatrixThreadType(String id, Renderer renderer, double elementWidth, double elementHeight, CollisionBounds cb, CollisionGroup cg, Font font, int fontHeight, int charCount, Color color, Color leadColor) {
        super(id, renderer, elementWidth, elementHeight, cb, cg);
        this.font = font;
        this.fontHeight = fontHeight;
        this.charCount = charCount;
        this.colors = new Color[charCount];
        for (int c = 0; c < charCount; ++c) {
            this.colors[c] = new Color(color.getRed() * (c + 2) / (charCount + 1), color.getGreen() * (c + 2) / (charCount + 1), color.getBlue() * (c + 2) / (charCount + 1));
        }
        this.colors[charCount - 1] = leadColor;
    }

    public Element createElement(Object id, double x, double y, double w, double h) throws Exception {
        MatrixThread el = new MatrixThread(id, x, y, this.elementWidth < 0.0 ? w : this.elementWidth, this.elementHeight < 0.0 ? h : this.elementHeight, (ElementType)this, this.renderer, this.charCount, this.colors, this.font, this.fontHeight);
        el.setCollisionBounds(this.collisionBounds);
        el.setCollisionGroup(this.collisionGroup);
        el.setPower(this.getPower());
        return el;
    }
}

