/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.spacekiller.level.weapon;

import com.spacekiller.game2d.ElementType;
import com.spacekiller.game2d.ResourceRegistry;
import com.spacekiller.spacekiller.AbstractWeaponType;
import com.spacekiller.spacekiller.Level;
import com.spacekiller.spacekiller.Ship;
import com.spacekiller.spacekiller.Weapon;
import com.spacekiller.spacekiller.WeaponType;
import com.spacekiller.spacekiller.weapons.BulletType;
import com.spacekiller.spacekiller.weapons.DefaultGun;

public class EnemyWeaponTypeTank01
extends AbstractWeaponType {
    public EnemyWeaponTypeTank01() {
        super(102001);
        this.setEnemyWeaponType(true);
    }

    public Weapon createWeapon(Level level, Ship ship) throws Exception {
        ResourceRegistry registry = level.getRegistry();
        BulletType templateBulletType = (BulletType)registry.getElementType("enemyBulletType02b");
        BulletType bulletType = templateBulletType.cloneBulletType();
        bulletType.setCollisionGroup(level.getEnemyBulletCollisionGroup());
        DefaultGun defaultGun = new DefaultGun((WeaponType)this, level, ship);
        defaultGun.setRepeatDelay(0L);
        defaultGun.setPower(20.0);
        defaultGun.setBulletCount(1000);
        defaultGun.setBulletElementType((ElementType)bulletType);
        defaultGun.setBulletSpeedX(-0.5);
        defaultGun.setBulletSpeedY(-0.5);
        defaultGun.setBulletStartX(-bulletType.getElementWidth() / 2.0);
        defaultGun.setBulletStartY(-bulletType.getElementHeight() / 2.0);
        return defaultGun;
    }
}

