/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.spacekiller.level.weapon;

import com.spacekiller.game2d.ElementType;
import com.spacekiller.game2d.ResourceRegistry;
import com.spacekiller.spacekiller.AbstractWeaponType;
import com.spacekiller.spacekiller.Level;
import com.spacekiller.spacekiller.Ship;
import com.spacekiller.spacekiller.Weapon;
import com.spacekiller.spacekiller.WeaponSlot;
import com.spacekiller.spacekiller.WeaponType;
import com.spacekiller.spacekiller.weapons.BulletType;
import com.spacekiller.spacekiller.weapons.DefaultGun;
import com.spacekiller.spacekiller.weapons.Multiplexer;
import java.util.ArrayList;

public class WeaponType02
extends AbstractWeaponType {
    public WeaponType02() {
        super(100002);
        this.setTitle("Double gun");
    }

    public Weapon createWeapon(Level level, Ship ship) throws Exception {
        ResourceRegistry registry = level.getRegistry();
        BulletType templateBulletType = (BulletType)registry.getElementType("bullet_010");
        switch (level.getOrientation()) {
            case 2: {
                templateBulletType = (BulletType)registry.getElementType("bullet_010_up");
            }
        }
        BulletType bulletType = templateBulletType.cloneBulletType();
        bulletType.setCollisionGroup(ship.getWeaponCollisionGroup());
        DefaultGun topGun = new DefaultGun((WeaponType)this, level, ship);
        topGun.setPower(150.0);
        topGun.setBulletPower(40.0);
        topGun.setBulletElementType((ElementType)bulletType);
        topGun.setBulletAudioClip(registry.getAudioClip("defaultBulletClip"));
        this.setupDefaultGunOrientation(ship, topGun, 2.0, -0.1);
        DefaultGun bottomGun = new DefaultGun((WeaponType)this, level, ship);
        bottomGun.setPower(150.0);
        bottomGun.setBulletPower(40.0);
        bottomGun.setBulletElementType((ElementType)bulletType);
        bottomGun.setBulletAudioClip(null);
        this.setupDefaultGunOrientation(ship, bottomGun, 2.0, 0.1);
        ArrayList<DefaultGun> multiGunList = new ArrayList<DefaultGun>();
        multiGunList.add(topGun);
        multiGunList.add(bottomGun);
        double multiPower = topGun.getBulletPower() + bottomGun.getBulletPower();
        Multiplexer multiGun = new Multiplexer((WeaponType)this, level, ship, multiGunList, multiPower);
        return multiGun;
    }

    public boolean installWeapon(Ship ship, Weapon weapon) {
        Multiplexer multiGun = (Multiplexer)weapon;
        DefaultGun topGun = (DefaultGun)multiGun.getWeaponAt(0);
        DefaultGun bottomGun = (DefaultGun)multiGun.getWeaponAt(1);
        int slots = ship.getWeaponSlotCount();
        int topSlotIndex = slots > 1 ? 1 : 0;
        int bottomSlotIndex = slots > 2 ? 2 : 0;
        WeaponSlot topSlot = ship.getWeaponSlotAt(topSlotIndex);
        WeaponSlot bottomSlot = ship.getWeaponSlotAt(bottomSlotIndex);
        this.setupWeaponSlot(topSlot, (Weapon)topGun);
        this.setupWeaponSlot(bottomSlot, (Weapon)bottomGun);
        this.setupWeaponSet(this.chooseWeaponSet(ship), weapon);
        return true;
    }
}

