/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.spacekiller.level.weapon;

import com.spacekiller.game2d.ElementType;
import com.spacekiller.game2d.ResourceRegistry;
import com.spacekiller.spacekiller.AbstractWeaponType;
import com.spacekiller.spacekiller.Level;
import com.spacekiller.spacekiller.Ship;
import com.spacekiller.spacekiller.Weapon;
import com.spacekiller.spacekiller.WeaponType;
import com.spacekiller.spacekiller.weapons.BulletType;
import com.spacekiller.spacekiller.weapons.DefaultGun;
import com.spacekiller.spacekiller.weapons.RocketLauncher;

public class WeaponType06
extends AbstractWeaponType {
    public WeaponType06() {
        super(100006);
        this.setTitle("Missile");
    }

    public Weapon createWeapon(Level level, Ship ship) throws Exception {
        ResourceRegistry registry = level.getRegistry();
        BulletType templateBulletType = (BulletType)registry.getElementType("rocketBulletType");
        BulletType bulletType = templateBulletType.cloneBulletType();
        bulletType.setCollisionGroup(ship.getWeaponCollisionGroup());
        RocketLauncher rocketLauncher = new RocketLauncher((WeaponType)this, level, ship);
        rocketLauncher.setBulletElementType((ElementType)bulletType);
        rocketLauncher.setPower(300.0);
        rocketLauncher.setBulletPower(100.0);
        this.setupDefaultGunOrientation(ship, (DefaultGun)rocketLauncher, 1.0);
        rocketLauncher.setRepeatDelay(200L);
        rocketLauncher.setBulletAudioClip(registry.getAudioClip("rocketBulletClip"));
        return rocketLauncher;
    }
}

