/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.file;

import com.spacekiller.util.Data;
import com.spacekiller.util.file.AbstractFileModel;
import com.spacekiller.util.file.DefaultFileAccess;
import com.spacekiller.util.file.FileAccess;
import com.spacekiller.util.file.FileAccessFactory;
import com.spacekiller.util.file.Page;
import com.spacekiller.util.file.PageConsumer;
import com.spacekiller.util.file.PageType;
import com.spacekiller.util.file.PageTypeRegistry;
import com.spacekiller.util.file.UnknownPage;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.StreamCorruptedException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DefaultFileModel
extends AbstractFileModel {
    public static final int FILE_MAGIC = 427163928;
    public static final int FILE_VERSION = 1;
    public static final int HEADER_MAGIC = -1610612726;
    public static final int FOOTER_MAGIC = -268435441;
    public static final int PAGE_MAGIC = 324508639;
    public static final int HOLE_MAGIC = 270544960;
    public static final byte CLEAN = 0;
    public static final byte DIRTY = -1;
    public static final long UNLIMITED = -1L;
    public static final int MAX_DESCR_LENGTH = Short.MAX_VALUE;
    private static final int FOOTER_LENGTH = 14;
    private static final int HOLE_HEADER_LENGTH = 13;
    private static final int PAGE_HEADER_LENGTH = 17;
    private static final int HEAD_BUFFER_SIZE = 20;
    private static final char[] HEX = "0123456789abcdef".toCharArray();
    private Logger logger = Logger.getLogger(this.getClass().getName());
    private boolean closed;
    private boolean readOnly;
    private long createTime;
    private long lastUpdate;
    private byte[] descr;
    private File file;
    private FileAccess access;
    private FileAccessFactory factory;
    private PageTypeRegistry registry;
    private long sizeLimit;
    private long length;
    private long footerOffset;
    private long firstOffset;
    private int pageCount;
    private Page firstPage;
    private Page lastPage;
    private int nextPageId;
    private int holeCount;
    private Hole firstHole;
    private Hole lastHole;
    private List modPages;
    private List modHoles;
    private boolean modFooter;
    private byte[] buf;

    public DefaultFileModel(PageTypeRegistry registry, FileAccessFactory factory, File file, long sizeLimit) throws IOException {
        this(registry, factory, file, sizeLimit, false);
    }

    protected DefaultFileModel(PageTypeRegistry registry, FileAccessFactory factory, File file, long sizeLimit, boolean readOnly) throws IOException {
        boolean exists = file.exists();
        this.readOnly = readOnly;
        this.file = file;
        this.factory = factory;
        this.registry = registry;
        this.sizeLimit = sizeLimit;
        RandomAccessFile raf = this.openRandomAccessFile();
        this.access = factory.createFileAccess(raf);
        this.length = this.access.length();
        this.closed = false;
        this.pageCount = 0;
        this.holeCount = 0;
        this.nextPageId = 1;
        this.footerOffset = -1L;
        this.modPages = new LinkedList();
        this.modHoles = new LinkedList();
        this.buf = new byte[20];
        if (exists) {
            this.readFileStructure(raf);
        } else {
            this.writeFileStructure();
        }
    }

    private RandomAccessFile openRandomAccessFile() throws IOException {
        String mode = this.readOnly ? "r" : "rw";
        return new RandomAccessFile(this.file, mode);
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public synchronized void flush() throws IOException {
        this.access.flush();
        boolean mod = false;
        if (!this.modPages.isEmpty()) {
            mod = true;
            for (Page page : this.modPages) {
                page.mod = false;
                this.writePageDirtyFlag(page, (byte)0);
            }
            this.modPages.clear();
        }
        if (!this.modHoles.isEmpty()) {
            mod = true;
            for (Hole hole : this.modHoles) {
                hole.mod = false;
                this.writeHoleDirtyFlag(hole, (byte)0);
            }
            this.modHoles.clear();
        }
        if (this.modFooter) {
            mod = true;
            this.writeFooterDirtyFlag((byte)0);
        }
        if (mod) {
            this.lastUpdate = System.currentTimeMillis();
            this.access.flush();
        }
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.flush();
        if (!this.readOnly) {
            // empty if block
        }
        this.closed = true;
        this.footerOffset = -1L;
        this.createTime = 0L;
        this.lastUpdate = 0L;
        this.access.close();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.close();
    }

    @Override
    protected void read(long pos, byte[] b, int off, int len) throws IOException {
        this.access.read(pos, b, off, len);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void write(Page page, int pos, byte[] b, int off, int len) throws IOException {
        long ofs;
        if (pos < 0) {
            throw new IOException("Invalid page position: " + pos);
        }
        if (pos + len > page.length) {
            throw new IOException("Invalid page position: " + (pos + len - 1) + " >= " + page.length);
        }
        DefaultFileModel defaultFileModel = this;
        synchronized (defaultFileModel) {
            ofs = page.offset + (long)pos;
            if (!page.mod) {
                if (this.readOnly) {
                    throw new IOException("File model is read-only: " + this);
                }
                page.mod = true;
                this.modPages.add(page);
                this.writePageDirtyFlag(page, (byte)-1);
            }
        }
        this.access.write(ofs, b, off, len);
    }

    @Override
    public synchronized boolean isEmpty() throws IOException {
        return this.pageCount < 1;
    }

    @Override
    public synchronized boolean getPages(PageConsumer dst) throws IOException {
        Page page = this.firstPage;
        while (page != null) {
            if (!dst.consume(page)) {
                return false;
            }
            page = page.next;
        }
        return true;
    }

    @Override
    public synchronized int getPageCount() throws IOException {
        return this.pageCount;
    }

    @Override
    public Page createPage(PageType type, int size) throws IOException {
        return this.createPage(-1, type, size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Page createPage(int id, PageType type, int size) throws IOException {
        if (type == null) {
            throw new IOException("Invalid page type specified: " + type);
        }
        if (size < 0) {
            throw new IOException("Invalid page size specified: " + size);
        }
        Page page = type.createPage();
        DefaultFileModel defaultFileModel = this;
        synchronized (defaultFileModel) {
            long pageOffset;
            if (page.model != null) {
                throw new IOException("Page already initialized!");
            }
            if (id <= 0) {
                id = this.nextPageId++;
            } else if (id >= this.nextPageId) {
                this.nextPageId = id + 1;
            }
            page.id = id;
            page.type = type.typeId;
            page.length = size;
            long reqSize = 17 + size;
            long newFooterOffset = this.footerOffset;
            Hole hole = null;
            if (this.holeCount > 0) {
                long minHoleSize = reqSize + 13L;
                hole = this.firstHole;
                while (hole != null && hole.size < minHoleSize && hole.size != reqSize) {
                    hole = hole.next;
                }
            }
            if (hole == null) {
                pageOffset = this.footerOffset;
                newFooterOffset = pageOffset + reqSize;
                if (this.sizeLimit > 0L && newFooterOffset + 14L > this.sizeLimit) {
                    return null;
                }
                page.next = null;
                if (this.lastPage == null) {
                    this.firstPage = page;
                    this.lastPage = page;
                    page.prev = null;
                } else {
                    this.lastPage.next = page;
                    page.prev = this.lastPage;
                    this.lastPage = page;
                }
                ++this.pageCount;
            } else {
                Page nextPage;
                pageOffset = hole.offset;
                Page prevPage = hole.prevPage;
                if (hole.size == reqSize) {
                    Hole prevHole = hole.prev;
                    Hole nextHole = hole.next;
                    if (prevHole == null) {
                        this.firstHole = nextHole;
                    } else {
                        prevHole.next = nextHole;
                    }
                    if (nextHole == null) {
                        this.lastHole = prevHole;
                    } else {
                        nextHole.prev = prevHole;
                    }
                    if (hole.mod) {
                        this.modHoles.remove(hole);
                    }
                    --this.holeCount;
                } else {
                    hole.offset += reqSize;
                    hole.size -= reqSize;
                    hole.prevPage = page;
                    this.writeHoleHeader(hole);
                    if (!hole.mod) {
                        hole.mod = true;
                        this.modHoles.add(hole);
                    }
                }
                Page page2 = nextPage = prevPage == null ? this.firstPage : prevPage.next;
                if (prevPage == null) {
                    this.firstPage = page;
                } else {
                    prevPage.next = page;
                }
                if (nextPage == null) {
                    this.lastPage = page;
                } else {
                    nextPage.prev = page;
                }
                page.prev = prevPage;
                page.next = nextPage;
                ++this.pageCount;
            }
            page.offset = pageOffset + 17L;
            page.model = this;
            this.footerOffset = newFooterOffset;
            this.length = newFooterOffset + 14L;
            this.writeFileFooter();
            this.writePageHeader(page);
            return page;
        }
    }

    @Override
    public synchronized void deletePage(Page page) throws IOException {
        boolean extendNext;
        if (page.model != this) {
            throw new IOException("Invalid page specified: " + page);
        }
        long offset = page.offset - 17L;
        long size = page.length + 17;
        Page prevPage = page.prev;
        Page nextPage = page.next;
        Hole prevHole = null;
        Hole nextHole = this.firstHole;
        while (nextHole != null && nextHole.offset <= offset) {
            prevHole = nextHole;
            nextHole = nextHole.next;
        }
        boolean extendPrev = prevHole != null && prevHole.offset + prevHole.size == offset;
        boolean bl = extendNext = nextHole != null && nextHole.offset == offset + size;
        if (extendPrev) {
            if (extendNext) {
                prevHole.size += size + nextHole.size;
                if (nextHole.mod) {
                    this.modHoles.remove(nextHole);
                }
                if ((nextHole = nextHole.next) == null) {
                    this.lastHole = prevHole;
                    if (!this.lastHole.mod) {
                        this.lastHole.mod = true;
                        this.modHoles.add(this.lastHole);
                    }
                } else {
                    nextHole.prev = prevHole;
                    if (!nextHole.mod) {
                        nextHole.mod = true;
                        this.modHoles.add(nextHole);
                    }
                }
                prevHole.next = nextHole;
                --this.holeCount;
                this.writeHoleHeader(prevHole);
                if (!prevHole.mod) {
                    prevHole.mod = true;
                    this.modHoles.add(prevHole);
                }
            } else {
                prevHole.size += size;
                this.writeHoleHeader(prevHole);
                if (!prevHole.mod) {
                    prevHole.mod = true;
                    this.modHoles.add(prevHole);
                }
            }
        } else if (extendNext) {
            nextHole.offset -= size;
            nextHole.size += size;
            nextHole.prevPage = prevPage;
            this.writeHoleHeader(nextHole);
            if (!nextHole.mod) {
                nextHole.mod = true;
                this.modHoles.add(nextHole);
            }
        } else {
            Hole newHole = new Hole(offset, size);
            newHole.prev = prevHole;
            newHole.next = nextHole;
            newHole.prevPage = prevPage;
            if (prevHole == null) {
                this.firstHole = newHole;
            } else {
                prevHole.next = newHole;
                if (!prevHole.mod) {
                    prevHole.mod = true;
                    this.modHoles.add(prevHole);
                }
            }
            if (nextHole == null) {
                this.lastHole = newHole;
            } else {
                nextHole.prev = newHole;
                if (!nextHole.mod) {
                    nextHole.mod = true;
                    this.modHoles.add(nextHole);
                }
            }
            ++this.holeCount;
            this.writeHoleHeader(newHole);
            newHole.mod = true;
            this.modHoles.add(newHole);
        }
        page.offset = -page.length;
        page.model = null;
        page.prev = null;
        page.next = null;
        if (prevPage == null) {
            this.firstPage = nextPage;
        } else {
            prevPage.next = nextPage;
        }
        if (nextPage == null) {
            this.lastPage = prevPage;
        } else {
            nextPage.prev = prevPage;
        }
        --this.pageCount;
        if (page.mod) {
            page.mod = false;
            this.modPages.remove(page);
        }
        this.writeFileFooter();
    }

    @Override
    public synchronized void compact() throws IOException {
        boolean finer = this.logger.isLoggable(Level.FINER);
        if (finer) {
            this.logger.finer("compact: " + this.file + ", holes=" + this.holeCount);
        }
        if (this.holeCount < 1) {
            return;
        }
        this.check();
        this.access.close();
        this.access = null;
        RandomAccessFile raf = this.openRandomAccessFile();
        this.access = new DefaultFileAccess(raf);
        byte[] tmp = new byte[65536];
        Hole hole = this.firstHole;
        long newFooterOfs = hole.offset;
        while (hole != null) {
            Page p1;
            Hole next = hole.next;
            Page prevPage = hole.prevPage;
            Page page = p1 = prevPage == null ? this.firstPage : prevPage.next;
            if (next == null && p1 == null) break;
            long pageOfs = p1.offset - 17L;
            long expectedPageOffset = hole.offset + hole.size;
            if (pageOfs != expectedPageOffset) {
                throw new IOException("Unexpected page offset: " + pageOfs + " != " + expectedPageOffset + ", page=" + p1 + ", hole=" + hole);
            }
            this.writeHoleDirtyFlag(hole, (byte)-1);
            long copyLen = 0L;
            long newPageOfs = newFooterOfs + 17L;
            Page p = p1;
            while (p != null) {
                if (!p.mod) {
                    p.mod = true;
                    this.modPages.add(p);
                    this.writePageDirtyFlag(p, (byte)-1);
                }
                p.offset = newPageOfs;
                long pageLen = 17 + p.length;
                copyLen += pageLen;
                newPageOfs += pageLen;
                p = p.next;
            }
            while (copyLen > 0L) {
                int n = (int)Math.min(copyLen, (long)tmp.length);
                raf.seek(pageOfs);
                raf.readFully(tmp, 0, n);
                raf.seek(newFooterOfs);
                raf.write(tmp, 0, n);
                pageOfs += (long)n;
                newFooterOfs += (long)n;
                copyLen -= (long)n;
            }
            if (finer) {
                this.logger.finer(" - compacted: " + hole.size + " bytes, moved: " + copyLen + " bytes");
            }
            hole = next;
        }
        this.firstHole = null;
        this.lastHole = null;
        this.holeCount = 0;
        this.modHoles.clear();
        this.footerOffset = newFooterOfs;
        this.writeFileFooter();
        long newLength = this.footerOffset + 14L;
        raf.setLength(newLength);
        this.length = newLength;
        this.check();
        this.access = this.factory.createFileAccess(raf);
        this.flush();
    }

    @Override
    public synchronized long length() throws IOException {
        return this.length;
    }

    public String getDescription() {
        return new String(this.descr);
    }

    public File getFile() {
        return this.file;
    }

    @Override
    public void dump(int level, BufferedWriter out) throws IOException {
        out.write("File: " + this.file);
        out.newLine();
        out.write("Size: " + this.length);
        out.newLine();
        Page page = this.firstPage;
        Hole hole = this.firstHole;
        byte[] buf = new byte[32768];
        while (true) {
            if (page != null && (hole == null || page.offset < hole.offset)) {
                long ofs = page.offset;
                int len = page.length;
                out.write("Page: type=0x" + Integer.toHexString(page.type) + ", id=" + page.id + ", ofs=" + ofs + ", len=" + len);
                out.newLine();
                if (level > 1000) {
                    page.dump(level, out);
                    if (level >= 4000) {
                        int n;
                        for (int pos = 0; pos < len; pos += n) {
                            n = Math.min(len - pos, buf.length);
                            this.read(ofs + (long)pos, buf, 0, n);
                            this.dump(buf, 0, n, out);
                        }
                    }
                }
                page = page.next;
                continue;
            }
            if (hole == null) break;
            out.write("Hole: ofs=" + hole.offset + ", len=" + hole.size);
            out.newLine();
            hole = hole.next;
        }
        out.write("Footer: ofs=" + this.footerOffset + ", len=" + 14);
        out.newLine();
        out.flush();
    }

    private void dump(byte[] buf, int off, int len, BufferedWriter out) throws IOException {
        int v;
        int j;
        int t;
        int k;
        int n = len;
        int m = n / 32;
        int o = 0;
        int x = 73;
        char[] cbuf = new char[x + 32];
        Arrays.fill(cbuf, ' ');
        for (int i = 0; i < m; ++i) {
            k = 0;
            t = x;
            for (j = 0; j < 8; ++j) {
                int z = o + 4;
                while (o < z) {
                    v = buf[o++] & 0xFF;
                    cbuf[k++] = HEX[v >> 4];
                    cbuf[k++] = HEX[v & 0xF];
                    cbuf[t++] = v > 31 && v < 127 ? (int)v : 46;
                }
                cbuf[k++] = 32;
            }
            out.write(cbuf);
            out.newLine();
        }
        Arrays.fill(cbuf, ' ');
        m = n % 32;
        if (m > 0) {
            k = 0;
            t = x;
            for (j = 0; j < m; ++j) {
                v = buf[o++] & 0xFF;
                cbuf[k++] = HEX[v >> 4];
                cbuf[k++] = HEX[v & 0xF];
                int n2 = cbuf[t++] = v > 31 && v < 127 ? (int)v : 46;
                if (j % 4 != 3) continue;
                cbuf[k++] = 32;
            }
            out.write(cbuf);
            out.newLine();
        }
    }

    public synchronized void check() throws IOException {
        Page nextPage = this.firstPage;
        Hole nextHole = this.firstHole;
        Page expectedLastPage = null;
        Hole expectedLastHole = null;
        HashSet<Page> pageSet = new HashSet<Page>();
        HashSet<Hole> holeSet = new HashSet<Hole>();
        int numPages = 0;
        int numHoles = 0;
        long expectedOffset = this.firstOffset;
        while (true) {
            if (nextPage != null && (nextHole == null || nextPage.offset < nextHole.offset)) {
                if (nextPage.offset - 17L != expectedOffset) {
                    throw new IOException("Unexpected page offset: " + nextPage + ", offset: " + (nextPage.offset - 17L) + " != " + expectedOffset);
                }
                ++numPages;
                pageSet.add(nextPage);
                expectedLastPage = nextPage;
                expectedOffset += (long)(nextPage.length + 17);
                nextPage = nextPage.next;
                continue;
            }
            if (nextHole == null) break;
            if (nextHole.offset != expectedOffset) {
                throw new IOException("Unexpected hole offset: " + nextHole + ", expected offset: " + expectedOffset);
            }
            ++numHoles;
            holeSet.add(nextHole);
            expectedLastHole = nextHole;
            expectedOffset += nextHole.size;
            nextHole = nextHole.next;
        }
        if (numPages != this.pageCount) {
            throw new IOException("Unexpected page count: " + numPages + " != " + this.pageCount);
        }
        if (numHoles != this.holeCount) {
            throw new IOException("Unexpected hole count: " + numHoles + " != " + this.holeCount);
        }
        if (this.lastPage != expectedLastPage) {
            throw new IOException("Unexpected last page: " + this.lastPage + " != " + expectedLastPage);
        }
        if (this.lastHole != expectedLastHole) {
            throw new IOException("Unexpected last hole: " + this.lastHole + " != " + expectedLastHole);
        }
        if (this.footerOffset != expectedOffset) {
            throw new IOException("Unexpected footer offset: " + this.footerOffset + " != " + expectedOffset);
        }
        for (Page page : this.modPages) {
            if (pageSet.remove(page)) continue;
            throw new IOException("Modified page not found: " + page);
        }
        for (Hole hole : this.modHoles) {
            if (holeSet.remove(hole)) continue;
            throw new IOException("Modified hole not found: " + hole);
        }
    }

    private String getVersionString() {
        Package pkg = Package.getPackage("com.spacekiller.util.file");
        String version = pkg == null ? null : pkg.getImplementationVersion();
        String title = "mmutil_file";
        return version == null ? title : title + " " + version;
    }

    private String getTimeString(Date date) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return format.format(date);
    }

    private void writeFileStructure() throws IOException {
        if (this.footerOffset >= 0L) {
            throw new IOException("File already initialized!");
        }
        String str = "--------------------------------------\nThis file contains binary data.\nPlease do not edit this file manually!\n--------------------------------------\nCreated: " + this.getTimeString(new Date()) + "\n" + "Using: " + this.getVersionString() + "\n";
        this.descr = str.getBytes();
        this.firstOffset = this.footerOffset = (long)this.computeFileHeaderLength(this.descr.length);
        this.createTime = System.currentTimeMillis();
        this.lastUpdate = System.currentTimeMillis();
        this.writeFileHeader();
        this.writeFileFooter();
    }

    private void readFileStructure(RandomAccessFile raf) throws IOException {
        byte res;
        boolean finer = this.logger.isLoggable(Level.FINER);
        if (finer) {
            this.logger.finer("readFileStructure: " + this.file);
        }
        byte[] buf = new byte[8];
        raf.seek(0L);
        raf.readFully(buf, 0, buf.length);
        long pos = buf.length;
        int magic = Data.getInt((byte[])buf, (int)0);
        if (magic != 427163928) {
            throw new StreamCorruptedException("Invalid file magic: " + magic);
        }
        char descrLen = DefaultFileModel.decodeC4B(buf, 4);
        buf = new byte[32 + descrLen];
        raf.readFully(buf, 0, buf.length);
        pos += (long)buf.length;
        if (buf[0] != 13) {
            throw new StreamCorruptedException("Invalid file header: " + buf[0]);
        }
        byte[] descr = new byte[descrLen];
        System.arraycopy(buf, 1, descr, 0, descrLen);
        int off = '\u0001' + descrLen;
        if (buf[off] != 26) {
            throw new StreamCorruptedException("Invalid file header: " + buf[off]);
        }
        this.descr = descr;
        magic = Data.getInt((byte[])buf, (int)(++off));
        off += 4;
        if (magic != -1610612726) {
            throw new StreamCorruptedException("Invalid header magic: " + magic);
        }
        int headerLen = Data.getInt((byte[])buf, (int)off);
        int fileVer = Data.getInt((byte[])buf, (int)(off += 4));
        off += 4;
        if (fileVer != 1) {
            throw new StreamCorruptedException("Invalid file version: " + fileVer);
        }
        int expectedHeaderLen = 40 + descrLen;
        if (headerLen != expectedHeaderLen) {
            throw new StreamCorruptedException("Invalid header length: " + headerLen + " != " + expectedHeaderLen);
        }
        byte dirty = buf[off++];
        if ((res = buf[off++]) != 0) {
            throw new StreamCorruptedException("Invalid reserved flag: " + res);
        }
        this.createTime = Data.getLong((byte[])buf, (int)off);
        this.lastUpdate = Data.getLong((byte[])buf, (int)(off += 8));
        off += 8;
        this.pageCount = 0;
        this.firstPage = null;
        this.lastPage = null;
        this.holeCount = 0;
        this.firstHole = null;
        this.lastHole = null;
        long footOfs = -1L;
        int expectedPageCount = -1;
        int expectedHoleCount = -1;
        int dirtyPageCount = 0;
        int dirtyHoleCount = 0;
        boolean dirtyFooter = true;
        this.firstOffset = pos = (long)headerLen;
        int COMMON_LEN = 5;
        Page prevPage = null;
        Hole prevHole = null;
        if (finer) {
            this.logger.finer("Header: len=" + headerLen);
        }
        block5: while (pos < this.length) {
            raf.seek(pos);
            raf.readFully(buf, 0, 5);
            boolean dirt = buf[0] != 0;
            int type = Data.getInt((byte[])buf, (int)1);
            switch (type) {
                case 324508639: {
                    PageType pageType;
                    if (dirt) {
                        this.logger.warning("Dirty page: pos=" + pos);
                        ++dirtyPageCount;
                    }
                    raf.readFully(buf, 0, 12);
                    int pageTypeId = Data.getInt((byte[])buf, (int)0);
                    int pageId = Data.getInt((byte[])buf, (int)4);
                    int dataLen = Data.getInt((byte[])buf, (int)8);
                    if (dataLen < 0) {
                        throw new StreamCorruptedException("Invalid page length: pos=" + pos + ", id=" + pageId + ", len=" + dataLen);
                    }
                    if (finer) {
                        this.logger.finer("Page: id=" + pageId + ", pos=" + pos + ", dataLen=" + dataLen + ", type=0x" + Integer.toHexString(pageTypeId));
                    }
                    Page page = (pageType = this.registry.getPageType(pageTypeId)) != null ? pageType.loadPage(raf) : new UnknownPage();
                    page.id = pageId;
                    page.type = pageTypeId;
                    page.offset = pos + 17L;
                    page.length = dataLen;
                    page.prev = prevPage;
                    page.next = null;
                    page.model = this;
                    if (prevPage == null) {
                        this.firstPage = page;
                    } else {
                        prevPage.next = page;
                    }
                    ++this.pageCount;
                    if (pageId >= this.nextPageId) {
                        this.nextPageId = pageId + 1;
                    }
                    prevPage = page;
                    pos += (long)(17 + dataLen);
                    continue block5;
                }
                case 270544960: {
                    if (dirt) {
                        this.logger.warning("Dirty hole: pos=" + pos);
                        ++dirtyHoleCount;
                    }
                    raf.readFully(buf, 0, 8);
                    long holeLen = Data.getLong((byte[])buf, (int)0);
                    if (holeLen < 0L) {
                        throw new StreamCorruptedException("Invalid hole length: pos=" + pos + ", len=" + holeLen);
                    }
                    if (finer) {
                        this.logger.finer("Hole: ofs=" + pos + ", holeLen=" + holeLen);
                    }
                    Hole hole = new Hole(pos, 13L + holeLen);
                    hole.prev = prevHole;
                    hole.next = null;
                    hole.prevPage = prevPage;
                    if (prevHole == null) {
                        this.firstHole = hole;
                    } else {
                        prevHole.next = hole;
                    }
                    ++this.holeCount;
                    prevHole = hole;
                    pos += hole.size;
                    continue block5;
                }
                case -268435441: {
                    if (finer) {
                        this.logger.finer("Footer: ofs=" + pos);
                    }
                    if (footOfs >= 0L) {
                        throw new StreamCorruptedException("Duplicate file footer: " + footOfs + ", " + pos);
                    }
                    dirtyFooter = dirt;
                    footOfs = pos;
                    raf.readFully(buf, 0, 9);
                    expectedPageCount = Data.getInt((byte[])buf, (int)0);
                    expectedHoleCount = Data.getInt((byte[])buf, (int)4);
                    byte b = buf[8];
                    if (b != 26) {
                        throw new StreamCorruptedException("Invalid end of footer: " + b);
                    }
                    pos += 14L;
                    continue block5;
                }
            }
            throw new StreamCorruptedException("Invalid structure type " + type + " at position " + pos);
        }
        this.lastPage = prevPage;
        this.lastHole = prevHole;
        this.footerOffset = footOfs;
        if (footOfs < 0L) {
            throw new StreamCorruptedException("Missing file footer");
        }
        if (this.length != pos) {
            throw new StreamCorruptedException("Unexpected file length: " + this.length + " != " + pos);
        }
        if (this.pageCount != expectedPageCount) {
            throw new StreamCorruptedException("Unexpected page count: " + this.pageCount + " != " + expectedPageCount);
        }
        if (this.holeCount != expectedHoleCount) {
            throw new StreamCorruptedException("Unexpected hole count: " + this.holeCount + " != " + expectedHoleCount);
        }
        if (dirtyPageCount > 0) {
            throw new StreamCorruptedException("File is damaged: dirty pages=" + dirtyPageCount);
        }
        if (dirtyHoleCount > 0) {
            throw new StreamCorruptedException("File is damaged: dirty holes=" + dirtyHoleCount);
        }
        if (dirtyFooter) {
            throw new StreamCorruptedException("File footer is dirty!");
        }
    }

    private int computeFileHeaderLength(int descrLen) {
        return 40 + descrLen;
    }

    private void writeFileHeader() throws IOException {
        if (this.descr.length > Short.MAX_VALUE) {
            throw new IOException("Invalid description length: " + this.descr.length + " > " + Short.MAX_VALUE);
        }
        char descrLen = (char)this.descr.length;
        int headerLen = this.computeFileHeaderLength(descrLen);
        byte[] buf = new byte[headerLen];
        Data.setInt((byte[])buf, (int)0, (int)427163928);
        DefaultFileModel.encodeC4B(descrLen, buf, 4);
        int off = 8;
        buf[off++] = 13;
        System.arraycopy(this.descr, 0, buf, off, descrLen);
        off += descrLen;
        buf[off++] = 26;
        Data.setInt((byte[])buf, (int)off, (int)-1610612726);
        Data.setInt((byte[])buf, (int)(off += 4), (int)headerLen);
        Data.setInt((byte[])buf, (int)(off += 4), (int)1);
        off += 4;
        buf[off++] = -1;
        buf[off++] = 0;
        Data.setLong((byte[])buf, (int)off, (long)this.createTime);
        Data.setLong((byte[])buf, (int)(off += 8), (long)this.lastUpdate);
        if ((off += 8) != headerLen) {
            throw new IOException("Invalid header length: " + off + " != " + headerLen);
        }
        if (this.footerOffset < 0L) {
            this.footerOffset = headerLen;
        }
        this.access.write(0L, buf, 0, headerLen);
    }

    private void writeFileFooter() throws IOException {
        this.modFooter = true;
        this.buf[0] = -1;
        Data.setInt((byte[])this.buf, (int)1, (int)-268435441);
        Data.setInt((byte[])this.buf, (int)5, (int)this.pageCount);
        Data.setInt((byte[])this.buf, (int)9, (int)this.holeCount);
        this.buf[13] = 26;
        this.access.write(this.footerOffset, this.buf, 0, 14);
    }

    private void writeFooterDirtyFlag(byte dirty) throws IOException {
        this.buf[0] = dirty;
        this.access.write(this.footerOffset, this.buf, 0, 1);
    }

    private void writePageHeader(Page page) throws IOException {
        if (!page.mod) {
            page.mod = true;
            this.modPages.add(page);
        }
        this.buf[0] = -1;
        Data.setInt((byte[])this.buf, (int)1, (int)324508639);
        Data.setInt((byte[])this.buf, (int)5, (int)page.type);
        Data.setInt((byte[])this.buf, (int)9, (int)page.id);
        Data.setInt((byte[])this.buf, (int)13, (int)page.length);
        this.access.write(page.offset - 17L, this.buf, 0, 17);
    }

    private void writePageDirtyFlag(Page page, byte dirty) throws IOException {
        this.buf[0] = dirty;
        this.access.write(page.offset - 17L, this.buf, 0, 1);
    }

    private void writeHoleHeader(Hole hole) throws IOException {
        byte[] buf = new byte[13];
        buf[0] = -1;
        Data.setInt((byte[])buf, (int)1, (int)270544960);
        Data.setLong((byte[])buf, (int)5, (long)(hole.size - 13L));
        this.access.write(hole.offset, buf, 0, 13);
    }

    private void writeHoleDirtyFlag(Hole hole, byte dirty) throws IOException {
        this.buf[0] = dirty;
        this.access.write(hole.offset, this.buf, 0, 1);
    }

    static void encodeC4B(char c, byte[] b, int ofs) {
        b[ofs++] = (byte)(32 + (c & 0xF));
        b[ofs++] = (byte)(32 + (c >> 4 & 0xF));
        b[ofs++] = (byte)(32 + (c >> 8 & 0xF));
        b[ofs++] = (byte)(32 + (c >> 12 & 0xF));
    }

    static char decodeC4B(byte[] b, int ofs) throws IOException {
        int i = b[ofs++] - 32;
        i |= b[ofs++] - 32 << 4;
        i |= b[ofs++] - 32 << 8;
        return (char)(i |= b[ofs++] - 32 << 12);
    }

    protected static class Hole {
        Hole prev;
        Hole next;
        long offset;
        long size;
        Page prevPage;
        boolean mod;

        public Hole(long offset, long size) {
            this.offset = offset;
            this.size = size;
        }

        public String toString() {
            return super.toString() + "[offset=" + this.offset + ", size=" + this.size + "]";
        }
    }
}

