/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.member.plugin;

import com.spacekiller.util.Platform;
import com.spacekiller.util.Plugin;
import com.spacekiller.util.member.DefaultUserRegistryManager;
import com.spacekiller.util.member.FileUserRegistry;
import com.spacekiller.util.member.UserRegistry;
import com.spacekiller.util.member.UserRegistryManager;
import com.spacekiller.util.member.plugin.UserRegistryView;
import com.spacekiller.util.tooling.Tool;
import com.spacekiller.util.workbench.View;
import com.spacekiller.util.workbench.Workbench;
import com.spacekiller.util.workbench.WorkbenchAction;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MemberPlugin
extends Plugin {
    private static Logger logger = Logger.getLogger(MemberPlugin.class.getName());
    public static final String MEMBER_PLUGIN_ID = "com.spacekiller.util.member.plugin";
    protected static final String DEFAULT_USERREGISTRY_FILENAME = "users.registry";
    private UserRegistryManager userRegistryManager;

    public static MemberPlugin getInstance() throws Exception {
        return (MemberPlugin)Platform.getInstance().getPlugin(MEMBER_PLUGIN_ID);
    }

    protected void startup() {
        super.startup();
    }

    protected void shutdown() {
        super.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserRegistryManager getUserRegistryManager() {
        if (this.userRegistryManager == null) {
            MemberPlugin memberPlugin = this;
            synchronized (memberPlugin) {
                if (this.userRegistryManager == null) {
                    this.setUserRegistryManager(this.createUserRegistryManager());
                    this.initDefaultUserRegistry();
                }
            }
        }
        return this.userRegistryManager;
    }

    protected void setUserRegistryManager(UserRegistryManager userRegistryManager) {
        this.userRegistryManager = userRegistryManager;
    }

    protected UserRegistryManager createUserRegistryManager() {
        return new DefaultUserRegistryManager();
    }

    protected void initDefaultUserRegistry() {
        try {
            File configDir = Platform.getInstance().getConfigDir();
            File userRegFile = new File(configDir, DEFAULT_USERREGISTRY_FILENAME);
            FileUserRegistry fur = new FileUserRegistry(userRegFile);
            String userRegName = "default";
            this.getUserRegistryManager().addUserRegistry(userRegName, (UserRegistry)fur);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public static void openUserRegistryView(Workbench wb, Tool tool) throws Exception {
        UserRegistryView view = new UserRegistryView();
        view.setIcon(tool.getIcon());
        view.setTitle(tool.getText());
        view.setTooltip(tool.getTooltip());
        wb.getPerspective().addView((View)view);
    }

    public static class UserRegistryAction
    extends WorkbenchAction {
        public void invoke(Object instance) {
            try {
                MemberPlugin.openUserRegistryView(this.getWorkbench(instance), (Tool)this);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }
}

