/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.game2d.ext.jinput20;

import com.spacekiller.game2d.InputManager;
import com.spacekiller.game2d.InputProvider;
import com.spacekiller.game2d.ext.jinput20.JInputJoystickController;
import com.spacekiller.game2d.ext.jinput20.JInputJoystickManager;
import com.spacekiller.game2d.ext.jinput20.JInputKeyboardController;
import com.spacekiller.game2d.ext.jinput20.JInputKeyboardManager;
import com.spacekiller.game2d.ext.jinput20.JInputManager;
import com.spacekiller.game2d.ext.jinput20.JInputMouseController;
import com.spacekiller.game2d.ext.jinput20.JInputMouseManager;
import com.spacekiller.game2d.input.AbstractInputManager;
import java.util.ArrayList;
import net.java.games.input.Controller;
import net.java.games.input.ControllerEnvironment;
import net.java.games.input.Keyboard;
import net.java.games.input.Mouse;

public class JInput20InputProvider
implements InputProvider {
    private InputManager[] inputManagers;

    public InputManager[] getInputManagers() throws Exception {
        if (this.inputManagers == null) {
            ArrayList<AbstractInputManager> managers = new ArrayList<AbstractInputManager>();
            try {
                JInputManager jim = JInputManager.getInstance();
                ControllerEnvironment env = jim.getControllerEnvironment();
                System.out.println("ControllerEnvironment: " + env);
                Controller[] controllers = env.getControllers();
                if (controllers != null) {
                    System.out.println("Available JInput controllers: " + controllers.length);
                    for (int c = 0; c < controllers.length; ++c) {
                        Controller controller = controllers[c];
                        if (controller == null) continue;
                        Controller.Type type = controller.getType();
                        if (type == Controller.Type.MOUSE && controller instanceof Mouse) {
                            managers.add(new JInputMouseManager(new JInputMouseController((Mouse)controller)));
                            continue;
                        }
                        if (type == Controller.Type.KEYBOARD && controller instanceof Keyboard) {
                            managers.add(new JInputKeyboardManager(new JInputKeyboardController((Keyboard)controller)));
                            continue;
                        }
                        if (type == Controller.Type.STICK) {
                            managers.add(new JInputJoystickManager(new JInputJoystickController(controller)));
                            continue;
                        }
                        if (type == Controller.Type.FINGERSTICK) {
                            managers.add(new JInputJoystickManager(new JInputJoystickController(controller)));
                            continue;
                        }
                        if (type == Controller.Type.GAMEPAD) {
                            managers.add(new JInputJoystickManager(new JInputJoystickController(controller)));
                            continue;
                        }
                        System.out.println("TODO unknown controller: " + controller);
                        System.out.println("TODO unknown controller type: " + type);
                    }
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            int numManagers = managers.size();
            this.inputManagers = new InputManager[numManagers];
            this.inputManagers = managers.toArray(this.inputManagers);
        }
        return this.inputManagers;
    }
}

