/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.game2d.ext.jinput20;

import com.spacekiller.game2d.InputAxis;
import com.spacekiller.game2d.InputButton;
import com.spacekiller.game2d.InputController;
import com.spacekiller.game2d.Rumbler;
import java.util.HashMap;
import java.util.Map;
import net.java.games.input.Component;
import net.java.games.input.Keyboard;

public class JInputKeyboardController
implements InputController {
    private Keyboard keyboard;
    private JInputButton[] buttons;
    private Map mapKeycode;

    public JInputKeyboardController(Keyboard keyboard) {
        this.initJInputKeyboardController(keyboard);
    }

    protected void initJInputKeyboardController(Keyboard keyboard) {
        this.keyboard = keyboard;
        System.out.println("Keyboard: " + keyboard);
        Component[] axes = keyboard.getComponents();
        System.out.println("Number of key-buttons: " + axes.length);
        this.initKeycodeMap();
        this.buttons = new JInputButton[axes.length];
        for (int c = 0; c < axes.length; ++c) {
            String name = "" + axes[c].getIdentifier().getName();
            int keyCode = this.getKeycode(axes[c]);
            this.buttons[c] = new JInputButton(axes[c], name, keyCode);
        }
    }

    public Keyboard getKeyboard() {
        return this.keyboard;
    }

    protected void setKeyboard(Keyboard keyboard) {
        this.keyboard = keyboard;
    }

    public void poll() {
        this.keyboard.poll();
    }

    public InputAxis getAxisAt(int i) {
        return this.buttons[i];
    }

    public int getAxisCount() {
        return this.buttons.length;
    }

    public int getType() {
        return 1;
    }

    public InputAxis getAxisForKey(int keyCode) {
        int num = this.buttons.length;
        for (int c = 0; c < num; ++c) {
            if (this.buttons[c].getKeyCode() != keyCode) continue;
            return this.buttons[c];
        }
        return null;
    }

    protected int getKeycode(Component axis) {
        Integer keyCode = (Integer)this.mapKeycode.get(axis.getIdentifier());
        if (keyCode != null) {
            return keyCode;
        }
        return -1;
    }

    protected void initKeycodeMap() {
        this.mapKeycode = new HashMap();
        this.mapKeycode.put(Component.Identifier.Key.ESCAPE, new Integer(27));
        this.mapKeycode.put(Component.Identifier.Key.LCONTROL, new Integer(17));
        this.mapKeycode.put(Component.Identifier.Key.LSHIFT, new Integer(16));
        this.mapKeycode.put(Component.Identifier.Key.LEFT, new Integer(37));
        this.mapKeycode.put(Component.Identifier.Key.RIGHT, new Integer(39));
        this.mapKeycode.put(Component.Identifier.Key.UP, new Integer(38));
        this.mapKeycode.put(Component.Identifier.Key.DOWN, new Integer(40));
        this.mapKeycode.put(Component.Identifier.Key.SPACE, new Integer(32));
        this.mapKeycode.put(Component.Identifier.Key.RETURN, new Integer(10));
        this.mapKeycode.put(Component.Identifier.Key.MINUS, new Integer(45));
        this.mapKeycode.put(Component.Identifier.Key.ADD, new Integer(521));
    }

    public int getRumblerCount() {
        return 0;
    }

    public Rumbler getRumblerAt(int i) {
        return null;
    }

    public String toString() {
        return this.keyboard.getName();
    }

    protected class JInputButton
    implements InputButton {
        private Component axis;
        private String name;
        private int keyCode;

        public JInputButton(Component axis, String name, int keyCode) {
            this.axis = axis;
            this.name = name;
            this.keyCode = keyCode;
        }

        public boolean isPressed() {
            return this.axis.getPollData() != 0.0f;
        }

        public InputController getController() {
            return JInputKeyboardController.this;
        }

        public String getName() {
            return this.name;
        }

        public int getType() {
            return 1000;
        }

        public float getValue() {
            return this.axis.getPollData();
        }

        public boolean isAnalog() {
            return false;
        }

        public boolean isNormalized() {
            return false;
        }

        public boolean isRelative() {
            return false;
        }

        public boolean isPolling() {
            return true;
        }

        public int getKeyCode() {
            return this.keyCode;
        }

        public String toString() {
            return "JInputButton[axis=" + this.axis + ", keyCode=" + this.keyCode + "]";
        }
    }
}

