/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.game2d.ext.jinput20;

import com.spacekiller.game2d.ext.jinput.JInputPluginClassLoader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.StringTokenizer;
import net.java.games.input.Controller;
import net.java.games.input.ControllerEnvironment;
import net.java.games.input.Keyboard;
import net.java.games.input.Mouse;

public class JInputManager {
    public static final String SYSTEM_PROPERTY_LIBPATH = "jinput.lib.path";
    private static JInputManager instance;
    private ClassLoader pluginClassLoader;
    private ControllerEnvironment controllerEnvironment;

    private JInputManager(ClassLoader pluginClassLoader) {
        this.pluginClassLoader = pluginClassLoader;
    }

    public static JInputManager getInstance() throws Exception {
        if (instance == null) {
            try {
                ArrayList<URL> listJarPath = new ArrayList<URL>();
                ArrayList<String> listLibPath = new ArrayList<String>();
                URL url = JInputManager.class.getResource("/dxinput.jar");
                System.out.println("dxinput.jar >> " + url);
                if (url != null) {
                    File file = new File("dxinput.jar").getAbsoluteFile();
                    if (!file.exists()) {
                        JInputManager.extract(url, file);
                    }
                    listJarPath.add(file.toURI().toURL());
                }
                String libPath = System.getProperty(SYSTEM_PROPERTY_LIBPATH);
                System.out.println("jinput.lib.path = " + libPath);
                if (libPath != null) {
                    StringTokenizer tok = new StringTokenizer(libPath, File.pathSeparator, false);
                    while (tok.hasMoreTokens()) {
                        String s = tok.nextToken();
                        if (s.length() <= 0) continue;
                        listLibPath.add(s);
                    }
                }
                URL[] urls = new URL[listJarPath.size()];
                urls = listJarPath.toArray(urls);
                String[] libraryPath = new String[listLibPath.size()];
                libraryPath = listLibPath.toArray(libraryPath);
                ClassLoader parent = JInputManager.class.getClassLoader();
                JInputPluginClassLoader loader = new JInputPluginClassLoader(urls, libraryPath, parent);
                instance = new JInputManager((ClassLoader)loader);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
            catch (Throwable e) {
                e.printStackTrace();
                throw new Exception("" + e);
            }
        }
        return instance;
    }

    public ControllerEnvironment getControllerEnvironment() throws Exception {
        if (this.controllerEnvironment == null) {
            String pluginClassName = "net.java.games.input.DirectInputEnvironmentPlugin";
            System.out.println("Loading plugin: " + pluginClassName);
            try {
                Class<?> pluginClass = this.pluginClassLoader.loadClass(pluginClassName);
                this.controllerEnvironment = (ControllerEnvironment)pluginClass.newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
            catch (Throwable e) {
                e.printStackTrace();
                throw new Exception("" + e);
            }
        }
        return this.controllerEnvironment;
    }

    private Mouse getMouse() throws Exception {
        ControllerEnvironment env = this.getControllerEnvironment();
        Controller[] controllers = env.getControllers();
        for (int c = 0; c < controllers.length; ++c) {
            if (!(controllers[c] instanceof Mouse)) continue;
            return (Mouse)controllers[c];
        }
        return null;
    }

    private Keyboard getKeyboard() throws Exception {
        ControllerEnvironment env = this.getControllerEnvironment();
        Controller[] controllers = env.getControllers();
        for (int c = 0; c < controllers.length; ++c) {
            if (!(controllers[c] instanceof Keyboard)) continue;
            return (Keyboard)controllers[c];
        }
        return null;
    }

    private Controller getJoystick() throws Exception {
        ControllerEnvironment env = this.getControllerEnvironment();
        Controller[] controllers = env.getControllers();
        for (int c = 0; c < controllers.length; ++c) {
            Controller.Type type = controllers[c].getType();
            if (type != Controller.Type.STICK) continue;
            return controllers[c];
        }
        return null;
    }

    public boolean isSupported() {
        try {
            return this.getControllerEnvironment() != null;
        }
        catch (Throwable e) {
            System.out.println("JInput-Manager not supported: " + e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void extract(URL url, File dstFile) throws Exception {
        System.out.println("Extracting: " + url + " >> " + dstFile);
        InputStream in = url.openStream();
        try {
            FileOutputStream out = new FileOutputStream(dstFile);
            try {
                int num;
                byte[] buf = new byte[65536];
                while ((num = in.read(buf)) >= 0) {
                    out.write(buf, 0, num);
                }
            }
            finally {
                out.close();
            }
        }
        finally {
            in.close();
        }
    }
}

