/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.game2d.ext.jinput20;

import com.spacekiller.game2d.InputAxis;
import com.spacekiller.game2d.InputController;
import com.spacekiller.game2d.Rumbler;
import com.spacekiller.game2d.input.AbstractInputAxis;
import com.spacekiller.game2d.input.AbstractInputButton;
import java.util.ArrayList;
import net.java.games.input.Component;
import net.java.games.input.Mouse;

public class JInputMouseController
implements InputController {
    private Mouse mouse;
    private Component ax;
    private Component ay;
    private Component aw;
    private float x;
    private float y;
    private float w;
    private JInputMouseXAxis xAxis;
    private JInputMouseYAxis yAxis;
    private JInputMouseWheel wheel;
    private JInputMouseButton[] buttons;
    private InputAxis[] axes;

    public JInputMouseController(Mouse mouse) {
        this.initJInputMouseController(mouse);
    }

    protected void initJInputMouseController(Mouse mouse) {
        System.out.println("Mouse-Controller: " + mouse);
        if (mouse == null) {
            return;
        }
        this.mouse = mouse;
        this.ax = mouse.getX();
        this.ay = mouse.getY();
        this.aw = mouse.getWheel();
        ArrayList<Object> axisList = new ArrayList<Object>();
        this.xAxis = new JInputMouseXAxis("x-axis");
        axisList.add((Object)this.xAxis);
        this.yAxis = new JInputMouseYAxis("y-axis");
        axisList.add((Object)this.yAxis);
        this.wheel = new JInputMouseWheel("wheel");
        axisList.add((Object)this.wheel);
        Component[] comps = mouse.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            Component comp = comps[i];
            Component.Identifier id = comp.getIdentifier();
            if (!(id instanceof Component.Identifier.Button)) continue;
            JInputMouseButton button = new JInputMouseButton("" + comp.getIdentifier(), comp);
            axisList.add((Object)button);
        }
        this.axes = new InputAxis[axisList.size()];
        this.axes = axisList.toArray(this.axes);
    }

    protected Mouse getMouse() {
        return this.mouse;
    }

    protected void setMouse(Mouse mouse) {
        this.mouse = mouse;
    }

    public InputAxis getAxisAt(int i) {
        return this.axes[i];
    }

    public int getAxisCount() {
        return this.axes.length;
    }

    public void poll() {
        if (this.mouse.poll()) {
            this.x = this.ax.getPollData();
            this.y = this.ay.getPollData();
            this.w += this.aw.getPollData();
        }
    }

    public int getType() {
        return 2;
    }

    public InputAxis getAxisForKey(int keyCode) {
        return null;
    }

    public int getRumblerCount() {
        return 0;
    }

    public Rumbler getRumblerAt(int i) {
        return null;
    }

    public String toString() {
        return this.mouse.getName();
    }

    protected class JInputMouseButton
    extends AbstractInputButton {
        private Component axis;

        public JInputMouseButton(String name, Component axis) {
            super((InputController)JInputMouseController.this, name, 1000, -1);
            this.axis = axis;
        }

        public boolean isPressed() {
            return this.axis.getPollData() != 0.0f;
        }

        public float getValue() {
            return this.axis.getPollData();
        }

        public boolean isPolling() {
            return true;
        }
    }

    protected class JInputMouseWheel
    extends AbstractInputAxis {
        public JInputMouseWheel(String name) {
            super((InputController)JInputMouseController.this, name, 2020);
        }

        public float getValue() {
            return JInputMouseController.this.w;
        }

        public boolean isAnalog() {
            return true;
        }

        public boolean isNormalized() {
            return false;
        }

        public boolean isRelative() {
            return false;
        }

        public boolean isPolling() {
            return true;
        }
    }

    protected class JInputMouseYAxis
    extends AbstractInputAxis {
        public JInputMouseYAxis(String name) {
            super((InputController)JInputMouseController.this, name, 2001);
        }

        public float getValue() {
            return JInputMouseController.this.y;
        }

        public boolean isAnalog() {
            return true;
        }

        public boolean isNormalized() {
            return false;
        }

        public boolean isRelative() {
            return true;
        }

        public boolean isPolling() {
            return true;
        }
    }

    protected class JInputMouseXAxis
    extends AbstractInputAxis {
        public JInputMouseXAxis(String name) {
            super((InputController)JInputMouseController.this, name, 2000);
        }

        public float getValue() {
            return JInputMouseController.this.x;
        }

        public boolean isAnalog() {
            return true;
        }

        public boolean isNormalized() {
            return false;
        }

        public boolean isRelative() {
            return true;
        }

        public boolean isPolling() {
            return true;
        }
    }
}

