/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.workspace;

import com.spacekiller.util.swing.DocumentAdapter;
import com.spacekiller.util.workspace.DefaultProjectReference;
import com.spacekiller.util.workspace.ProjectReference;
import com.spacekiller.util.workspace.SerializedFileProjectPath;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyEditor;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class SerializedFileSavePropertyEditor
extends JPanel
implements PropertyEditor {
    private static final long serialVersionUID = 1090386481675423613L;
    private ProjectReference reference;
    private JTextField jTextFieldPath = null;
    private JButton jButton = null;

    public SerializedFileSavePropertyEditor() {
        this.initialize();
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
        GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
        GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
        JLabel jLabel = new JLabel();
        this.setLayout(new GridBagLayout());
        this.setSize(385, 81);
        gridBagConstraints8.gridx = 0;
        gridBagConstraints8.gridy = 0;
        gridBagConstraints8.insets = new Insets(4, 4, 4, 0);
        jLabel.setText("File Path:");
        jLabel.setIcon(new ImageIcon(this.getClass().getResource("/com/spacekiller/util/workspace/icons/filetarget16.gif")));
        gridBagConstraints10.gridx = 1;
        gridBagConstraints10.gridy = 0;
        gridBagConstraints10.weightx = 1.0;
        gridBagConstraints10.fill = 1;
        gridBagConstraints10.insets = new Insets(4, 4, 4, 4);
        gridBagConstraints11.gridx = 2;
        gridBagConstraints11.gridy = 0;
        gridBagConstraints11.insets = new Insets(4, 0, 4, 4);
        this.add((Component)jLabel, gridBagConstraints8);
        this.add((Component)this.getJTextFieldPath(), gridBagConstraints10);
        this.add((Component)this.getJButton(), gridBagConstraints11);
    }

    private JTextField getJTextFieldPath() {
        if (this.jTextFieldPath == null) {
            this.jTextFieldPath = new JTextField();
            this.jTextFieldPath.setColumns(20);
            this.jTextFieldPath.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

                protected void handle(DocumentEvent e) {
                    SerializedFileSavePropertyEditor.this.adjustValue();
                }
            });
        }
        return this.jTextFieldPath;
    }

    private JButton getJButton() {
        if (this.jButton == null) {
            this.jButton = new JButton();
            this.jButton.setText("");
            this.jButton.setMargin(new Insets(0, 0, 0, 0));
            this.jButton.setIcon(new ImageIcon(this.getClass().getResource("/com/spacekiller/util/workspace/icons/search.gif")));
            this.jButton.setToolTipText("Browse..");
            this.jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SerializedFileSavePropertyEditor.this.actionBrowse();
                }
            });
        }
        return this.jButton;
    }

    @Override
    public String getAsText() {
        return "" + this.reference;
    }

    @Override
    public Component getCustomEditor() {
        return this;
    }

    @Override
    public String getJavaInitializationString() {
        return null;
    }

    @Override
    public String[] getTags() {
        return null;
    }

    @Override
    public Object getValue() {
        return this.reference;
    }

    @Override
    public boolean isPaintable() {
        return false;
    }

    @Override
    public void paintValue(Graphics gfx, Rectangle box) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setValue(Object value) {
        this.setReference((ProjectReference)value);
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    public ProjectReference getReference() {
        return this.reference;
    }

    public void setReference(ProjectReference reference) {
        this.reference = reference;
    }

    protected void adjustValue() {
        ProjectReference old = this.reference;
        String path = this.getJTextFieldPath().getText().trim();
        String projectName = null;
        String projectClassName = null;
        String projectTypeName = null;
        SerializedFileProjectPath projectPath = null;
        if (path.length() > 0) {
            projectPath = new SerializedFileProjectPath(path);
        }
        this.reference = new DefaultProjectReference(projectName, projectClassName, projectTypeName, projectPath);
        this.firePropertyChange("value", old, this.reference);
    }

    protected void actionBrowse() {
        JFileChooser chooser = new JFileChooser();
        String path = this.getJTextFieldPath().getText();
        if (path.length() > 0) {
            for (File f = new File(path); f != null; f = f.getParentFile()) {
                if (!f.exists() || !f.isDirectory()) continue;
                chooser.setCurrentDirectory(f);
                break;
            }
        }
        chooser.setDialogType(1);
        int rc = chooser.showSaveDialog(this);
        if (rc != 0) {
            return;
        }
        File file = chooser.getSelectedFile();
        if (file != null) {
            this.getJTextFieldPath().setText(file.getPath());
        }
    }
}

