/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.heap;

import com.spacekiller.util.heap.AbstractPage;
import com.spacekiller.util.heap.Area;
import com.spacekiller.util.heap.Page;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public class ByteArrayPage
extends AbstractPage {
    protected final byte[] b;

    public ByteArrayPage(Area area, byte[] array) {
        super(area, array.length);
        this.b = array;
    }

    public final byte[] getArray() {
        return this.b;
    }

    @Override
    public void read(int off, byte[] arr, int ofs, int len) {
        System.arraycopy(this.b, off, arr, ofs, len);
    }

    @Override
    public void write(int off, byte[] arr, int ofs, int len) {
        System.arraycopy(arr, ofs, this.b, off, len);
    }

    @Override
    public void read(int off, ByteBuffer buf) {
        int len = buf.remaining();
        buf.put(this.b, off, len);
    }

    @Override
    public void write(int off, ByteBuffer buf) {
        int len = buf.remaining();
        buf.get(this.b, off, len);
    }

    @Override
    public void read(int off, OutputStream dst, int len) throws IOException {
        dst.write(this.b, off, len);
    }

    @Override
    public int write(int off, InputStream src, int len) throws IOException {
        return src.read(this.b, off, len);
    }

    @Override
    public void get(int off, Page dst, int ofs, int len) throws IOException {
        dst.write(ofs, this.b, off, len);
    }

    @Override
    public void put(int off, Page src, int ofs, int len) throws IOException {
        src.read(ofs, this.b, off, len);
    }

    @Override
    protected void dispose() throws IOException {
    }
}

