/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.heap;

import com.spacekiller.util.heap.AbstractArea;
import com.spacekiller.util.heap.AreaOptimizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DefaultAreaOptimizer
implements AreaOptimizer {
    private static final Logger logger = Logger.getLogger(DefaultAreaOptimizer.class.getName());
    public static final double DEFAULT_MIN_FREE_FACTOR = 0.2;
    public static final double DEFAULT_MAX_FREE_FACTOR = 0.8;
    public static final long DEFAULT_MAX_BYTES_PER_CYCLE = 0x500000L;
    private double minFreeFactor;
    private double maxFreeFactor;
    private long maxBytesPerCycle;
    private final AbstractArea area;

    public DefaultAreaOptimizer(AbstractArea area) {
        if (area == null) {
            throw new NullPointerException("area is null");
        }
        this.area = area;
        this.minFreeFactor = 0.2;
        this.maxFreeFactor = 0.8;
        this.maxBytesPerCycle = 0x500000L;
    }

    protected final AbstractArea getArea() {
        return this.area;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public long optimize(long amount, boolean force) {
        AbstractArea area = this.area;
        if (area == null) {
            return -1L;
        }
        long free = area.free;
        long size = area.size;
        if (size < 1L) {
            return -1L;
        }
        double factor = (double)free / (double)size;
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("optimize: area=" + area + ", free=" + free + ", size=" + size + ", factor=" + factor);
        }
        if (factor < this.minFreeFactor) {
            if (amount > this.maxBytesPerCycle && !force) {
                amount = this.maxBytesPerCycle;
            }
            long doneSize = 0L;
            try {
                long removedSize;
                long prepSize;
                long prepAmount = 0L;
                int pageSize = area.pageSize;
                long limit = area.limit();
                if (limit > 0L && size < limit) {
                    prepAmount = pageSize;
                }
                if (prepAmount > 0L && (prepSize = area.prepareNewPages(prepAmount)) > 0L) {
                    doneSize += prepSize;
                    amount -= prepSize;
                    if (logger.isLoggable(Level.FINER)) {
                        logger.finer("optimize: prepared new pages: " + prepSize + " bytes");
                    }
                }
                if (amount <= 0L) return doneSize;
                long swappedSize = area.evacuateOldBlocks(amount, force);
                if (swappedSize > 0L) {
                    doneSize += swappedSize;
                    amount -= swappedSize;
                    if (logger.isLoggable(Level.FINER)) {
                        logger.finer("optimize: swapped old blocks: " + swappedSize + " bytes");
                    }
                }
                if (amount <= 0L) return doneSize;
                free = area.free;
                size = area.size;
                if (size <= 0L || !((factor = (double)free / (double)size) < this.minFreeFactor) || (removedSize = area.removeEmptyPages(amount, force)) <= 0L) return doneSize;
                doneSize += removedSize;
                amount -= removedSize;
                if (!logger.isLoggable(Level.FINER)) return doneSize;
                logger.finer("optimize: removed empty pages: " + removedSize + " bytes");
                return doneSize;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
            return doneSize;
        }
        if (!(factor > this.maxFreeFactor) || amount <= 0L && !force) return -1L;
        long doneSize = 0L;
        try {
            long removedSize = area.removeEmptyPages(amount, force);
            if (removedSize > 0L) {
                doneSize += removedSize;
                amount -= removedSize;
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("optimize: removed empty pages: " + removedSize + " bytes");
                }
            }
            if (amount <= 0L) return doneSize;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        return doneSize;
    }

    public double getMinFreeFactor() {
        return this.minFreeFactor;
    }

    protected void setMinFreeFactor(double minFreeFactor) {
        if (minFreeFactor < 0.0 || minFreeFactor >= 1.0) {
            throw new IllegalArgumentException("minFreeFactor: " + minFreeFactor);
        }
        this.minFreeFactor = minFreeFactor;
    }

    public double getMaxFreeFactor() {
        return this.maxFreeFactor;
    }

    protected void setMaxFreeFactor(double maxFreeFactor) {
        if (maxFreeFactor < 0.0 || maxFreeFactor > 1.0) {
            throw new IllegalArgumentException("maxFreeFactor: " + maxFreeFactor);
        }
        this.maxFreeFactor = maxFreeFactor;
    }

    public long getMaxBytesPerCycle() {
        return this.maxBytesPerCycle;
    }

    protected void setMaxBytesPerCycle(long maxBytesPerCycle) {
        this.maxBytesPerCycle = maxBytesPerCycle;
    }
}

