/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.heap;

import com.spacekiller.util.heap.AbstractArea;
import com.spacekiller.util.heap.AbstractHeap;
import com.spacekiller.util.heap.Area;
import com.spacekiller.util.heap.AreaOptimizer;
import com.spacekiller.util.heap.DefaultAreaOptimizer;
import com.spacekiller.util.heap.HeapOptimizer;
import com.spacekiller.util.heap.Page;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DefaultHeapOptimizer
implements HeapOptimizer {
    private static final Logger logger = Logger.getLogger(DefaultHeapOptimizer.class.getName());
    private static final int DEFAULT_MIN_INTERVAL = 1000;
    private static final int DEFAULT_MAX_INTERVAL = 10000;
    private final Worker worker;
    private Thread thread;
    private long lastWorkTime;
    private int heapCount;
    private HeapEntry firstHeapEntry;
    private HeapEntry lastHeapEntry;
    private HeapEntry currentHeapEntry;
    private volatile boolean hintForce;
    private volatile Page hintPage;
    private volatile Area hintArea;
    private int currentInterval;
    private int minInterval = 1000;
    private int maxInterval = 10000;
    private long currentAmount;
    private long maxBytesPerSecond;
    private long maxBytesPerMilli;
    private long maxBytesPerCall;

    public DefaultHeapOptimizer() {
        this.setMaxBytesPerSecond(0x100000L);
        this.setMaxBytesPerCall(0x100000L);
        this.worker = new Worker();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void heapCreated(AbstractHeap heap, AreaOptimizer[] areaOptimizers) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("heapCreated: " + heap);
        }
        if (heap == null) {
            return;
        }
        WeakReference<AbstractHeap> heapRef = new WeakReference<AbstractHeap>(heap);
        HeapEntry heapEntry = new HeapEntry(heapRef);
        DefaultHeapOptimizer defaultHeapOptimizer = this;
        synchronized (defaultHeapOptimizer) {
            if (this.lastHeapEntry == null) {
                this.firstHeapEntry = heapEntry;
            } else {
                this.lastHeapEntry.next = heapEntry;
                heapEntry.prev = this.lastHeapEntry;
            }
            this.lastHeapEntry = heapEntry;
            ++this.heapCount;
            AreaEntry firstAreaEntry = null;
            AreaEntry lastAreaEntry = null;
            int num = areaOptimizers == null ? 0 : areaOptimizers.length;
            for (int i = 0; i < num; ++i) {
                AbstractArea area;
                AreaOptimizer optimizer = areaOptimizers[i];
                DefaultAreaOptimizer dao = null;
                if (optimizer != null && optimizer instanceof DefaultAreaOptimizer) {
                    dao = (DefaultAreaOptimizer)optimizer;
                }
                if (dao == null || (area = dao.getArea()) == null) continue;
                WeakReference<AbstractArea> areaRef = new WeakReference<AbstractArea>(area);
                AreaEntry newAreaEntry = new AreaEntry(heapRef, areaRef, optimizer);
                newAreaEntry.prev = lastAreaEntry;
                if (lastAreaEntry == null) {
                    firstAreaEntry = newAreaEntry;
                } else {
                    lastAreaEntry.next = newAreaEntry;
                }
                lastAreaEntry = newAreaEntry;
            }
            heapEntry.firstAreaEntry = firstAreaEntry;
            heapEntry.lastAreaEntry = lastAreaEntry;
        }
        this.startStopWorkerThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void heapRemoved(AbstractHeap heap) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("heapRemoved: " + heap);
        }
        if (heap == null) {
            return;
        }
        int removed = 0;
        DefaultHeapOptimizer defaultHeapOptimizer = this;
        synchronized (defaultHeapOptimizer) {
            HeapEntry heapEntry = this.firstHeapEntry;
            while (heapEntry != null) {
                HeapEntry nextEntry = heapEntry.next;
                AbstractHeap entryHeap = heapEntry.getHeap();
                if (entryHeap == null || entryHeap == heap) {
                    if (heapEntry.prev == null) {
                        this.firstHeapEntry = heapEntry.next;
                    } else {
                        heapEntry.prev.next = heapEntry.next;
                    }
                    if (heapEntry.next == null) {
                        this.lastHeapEntry = heapEntry.prev;
                    } else {
                        heapEntry.next.prev = heapEntry.prev;
                    }
                    --this.heapCount;
                    heapEntry.prev = null;
                    heapEntry.next = null;
                    ++removed;
                }
                heapEntry = nextEntry;
            }
        }
        if (removed > 0) {
            this.startStopWorkerThread();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void emptyPageDetected(Page page) {
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("emptyPageDetected: " + page);
        }
        if (page == null) {
            return;
        }
        Area area = page.getArea();
        if (area == null) {
            return;
        }
        Worker worker = this.worker;
        synchronized (worker) {
            this.hintPage = page;
            this.worker.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void startStopWorkerThread() {
        DefaultHeapOptimizer defaultHeapOptimizer = this;
        synchronized (defaultHeapOptimizer) {
            int heapCount = this.heapCount;
            if (heapCount < 1) {
                if (this.thread != null) {
                    if (this.thread.isAlive()) {
                        this.worker.cancel();
                    }
                    this.thread = null;
                }
                return;
            }
            if (this.thread != null && this.thread.isAlive()) {
                return;
            }
        }
        String threadName = "DefaultHeapOptimizer";
        int threadPrio = 4;
        Thread workerThread = new Thread((Runnable)this.worker, threadName);
        workerThread.setPriority(threadPrio);
        workerThread.setDaemon(true);
        this.thread = workerThread;
        workerThread.start();
    }

    protected long timeMillis() {
        return System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void optimize() {
        Worker worker = this.worker;
        synchronized (worker) {
            this.hintForce = true;
            this.worker.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int work() {
        long lastTime;
        long elapsed;
        long time = this.timeMillis();
        boolean hintForce = this.hintForce;
        if (hintForce) {
            this.hintForce = false;
        }
        Page hintPage = this.hintPage;
        Area hintArea = this.hintArea;
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("work: " + this + ", time=" + time + ", hintForce=" + hintForce + ", hintPage=" + hintPage + ", hintArea=" + hintArea);
        }
        if (hintPage != null) {
            this.hintPage = null;
            Area area = hintPage.getArea();
            if (area != null && area != hintArea) {
                this.hintArea = area;
            }
        }
        if ((elapsed = time - (lastTime = this.lastWorkTime)) < 0L) {
            elapsed = 0L;
        }
        long amount = this.currentAmount;
        if (elapsed > 0L) {
            amount += elapsed * this.maxBytesPerMilli;
        }
        if (amount > this.maxBytesPerCall) {
            amount = this.maxBytesPerCall;
        }
        this.lastWorkTime = time;
        long worked = 0L;
        HeapEntry nextHeapEntry = null;
        DefaultHeapOptimizer defaultHeapOptimizer = this;
        synchronized (defaultHeapOptimizer) {
            HeapEntry heapEntry = this.currentHeapEntry;
            int heapCount = this.heapCount;
            for (int i = 0; i < heapCount && (heapEntry != null || (heapEntry = this.firstHeapEntry) != null); ++i) {
                nextHeapEntry = heapEntry.next;
                long doneSize = this.workHeap(heapEntry, amount, hintForce);
                if (doneSize > 0L) {
                    worked += doneSize;
                    if ((amount -= doneSize) < 1L && !hintForce) break;
                }
                heapEntry = nextHeapEntry;
            }
        }
        this.currentHeapEntry = nextHeapEntry;
        int delay = this.currentInterval;
        if (worked > 0L) {
            delay = this.minInterval;
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Worked: amount=" + worked + ", decreased delay=" + delay);
            }
        } else {
            if ((delay += delay) > this.maxInterval) {
                delay = this.maxInterval;
            } else if (delay < this.minInterval) {
                delay = this.minInterval;
            }
            amount = 0L;
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Not worked: increased delay=" + delay);
            }
        }
        if (amount < 0L) {
            amount = 0L;
        }
        this.currentAmount = amount;
        this.currentInterval = delay;
        return delay;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long workHeap(HeapEntry heapEntry, long amount, boolean force) {
        long worked = 0L;
        HeapEntry heapEntry2 = heapEntry;
        synchronized (heapEntry2) {
            AreaEntry areaEntry = heapEntry.firstAreaEntry;
            if (areaEntry == null) {
                return -1L;
            }
            while (areaEntry != null) {
                long doneSize;
                AreaEntry nextAreaEntry = areaEntry.next;
                AbstractArea area = areaEntry.getArea();
                if (area != null && (doneSize = this.workArea(heapEntry, areaEntry, area, amount, force)) > 0L) {
                    worked += doneSize;
                    if ((amount -= doneSize) < 1L && !force) break;
                }
                areaEntry = nextAreaEntry;
            }
        }
        return worked;
    }

    protected long workArea(HeapEntry heapEntry, AreaEntry areaEntry, AbstractArea area, long amount, boolean force) {
        AreaOptimizer areaOptimizer = areaEntry.optimizer;
        if (areaOptimizer == null) {
            return -1L;
        }
        long doneSize = areaOptimizer.optimize(amount, force);
        return doneSize;
    }

    protected AreaOptimizer createAreaOptimizer(AbstractArea area, double minFreeFactor, double maxFreeFactor, long maxBytesPerCycle) throws IOException {
        DefaultAreaOptimizer optimizer = new DefaultAreaOptimizer(area);
        optimizer.setMinFreeFactor(minFreeFactor);
        optimizer.setMaxFreeFactor(maxFreeFactor);
        optimizer.setMaxBytesPerCycle(maxBytesPerCycle);
        return optimizer;
    }

    public int getMinInterval() {
        return this.minInterval;
    }

    protected void setMinInterval(int minInterval) {
        this.minInterval = minInterval;
    }

    public int getMaxInterval() {
        return this.maxInterval;
    }

    protected void setMaxInterval(int maxInterval) {
        this.maxInterval = maxInterval;
    }

    public long getMaxBytesPerSecond() {
        return this.maxBytesPerSecond;
    }

    protected void setMaxBytesPerSecond(long maxBytesPerSecond) {
        long perMilli = maxBytesPerSecond / 1000L;
        this.maxBytesPerSecond = maxBytesPerSecond;
        this.maxBytesPerMilli = perMilli;
    }

    public long getMaxBytesPerCall() {
        return this.maxBytesPerCall;
    }

    protected void setMaxBytesPerCall(long maxBytesPerCall) {
        this.maxBytesPerCall = maxBytesPerCall;
    }

    protected class AreaEntry {
        AreaEntry prev;
        AreaEntry next;
        private final Reference heapRef;
        private final Reference areaRef;
        protected AreaOptimizer optimizer;

        protected AreaEntry(Reference heapRef, Reference areaRef, AreaOptimizer optimizer) {
            this.heapRef = heapRef;
            this.areaRef = areaRef;
            this.optimizer = optimizer;
        }

        protected final AbstractHeap getHeap() {
            return (AbstractHeap)this.heapRef.get();
        }

        protected final AbstractArea getArea() {
            return (AbstractArea)this.areaRef.get();
        }
    }

    protected class HeapEntry {
        HeapEntry prev;
        HeapEntry next;
        private final Reference heapRef;
        AreaEntry firstAreaEntry;
        AreaEntry lastAreaEntry;

        public HeapEntry(Reference heapRef) {
            this.heapRef = heapRef;
        }

        protected final AbstractHeap getHeap() {
            return (AbstractHeap)this.heapRef.get();
        }
    }

    protected class Worker
    implements Runnable {
        private volatile boolean cancel;

        protected Worker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void cancel() {
            this.cancel = true;
            Worker worker = this;
            synchronized (worker) {
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("HeapOptimizer thread started: " + DefaultHeapOptimizer.this);
                }
                this.cancel = false;
                while (!this.cancel) {
                    int timeout = DefaultHeapOptimizer.this.work();
                    try {
                        Worker worker = this;
                        synchronized (worker) {
                            this.wait(timeout);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
            finally {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("HeapOptimizer thread stopped: " + DefaultHeapOptimizer.this);
                }
            }
        }
    }
}

