/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.heap;

import com.spacekiller.util.Data;
import com.spacekiller.util.heap.AbstractPage;
import com.spacekiller.util.heap.Area;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;

final class SupportJnaMemory {
    private static final Logger logger = Logger.getLogger(SupportJnaMemory.class.getName());
    private static final String JNA_MEMORY_PAGE_CLASS_NAME = "com.spacekiller.util.heap.jna.JnaMemoryPage";
    private static final String CREATE_JNA_MEMORY_PAGE_METHOD = "createJnaMemoryPage";
    private static Method createJnaMemoryPageMethod = SupportJnaMemory.initJnaMemoryPageCreateMethod();

    private SupportJnaMemory() {
    }

    private static Method initJnaMemoryPageCreateMethod() {
        try {
            Class<?> jnaMemoryPageClass = Class.forName(JNA_MEMORY_PAGE_CLASS_NAME);
            Method createMethod = jnaMemoryPageClass.getMethod(CREATE_JNA_MEMORY_PAGE_METHOD, Area.class, Integer.TYPE, byte[].class);
            return createMethod;
        }
        catch (ClassNotFoundException e) {
            logger.info("JnaMemoryPage is not supported: class not found");
        }
        catch (NoSuchMethodException e) {
            logger.info("JnaMemoryPage is not supported: constructor not found");
        }
        catch (Throwable e) {
            logger.info("JnaMemoryPage is not supported: " + e);
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        return null;
    }

    static final AbstractPage allocateJnaMemoryPage(Area area, int size, byte[] copyBuf) throws Exception {
        if (createJnaMemoryPageMethod == null) {
            return null;
        }
        return (AbstractPage)createJnaMemoryPageMethod.invoke(null, area, Data.toInteger((int)size), copyBuf);
    }
}

