/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.game2d.ext.clock;

import com.spacekiller.game2d.Clock;
import com.spacekiller.game2d.ClockType;
import java.lang.reflect.Method;

public class Java15ClockType
implements ClockType {
    private static final String Java15ClockClassName = "com.spacekiller.game2d.ext.clock.Java15Clock";

    public Clock createClock() throws Exception {
        Class<?> classJava15Clock = this.getClass().getClassLoader().loadClass(Java15ClockClassName);
        return (Clock)classJava15Clock.newInstance();
    }

    public String getId() {
        return "java15Clock";
    }

    public String getName() {
        return "Java 1.5 clock";
    }

    public String toString() {
        return this.getName();
    }

    public boolean isSupported() {
        try {
            Class<?> systemClass = Class.forName("java.lang.System");
            Method nanoTime = systemClass.getMethod("nanoTime", new Class[0]);
            System.out.println("Java 1.5 Clock supported: " + nanoTime);
            Clock clock = this.createClock();
            clock.millis();
            return true;
        }
        catch (Exception e) {
            System.out.println("Java 1.5 Clock is not supported: " + e);
            return false;
        }
    }
}

