/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.table;

import com.spacekiller.util.BeansToolkit;
import com.spacekiller.util.beans.DefaultProperty;
import com.spacekiller.util.beans.Property;
import com.spacekiller.util.beans.components.PropertyPage;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPanel;
import javax.swing.table.TableModel;

public class RowEditorPanel
extends JPanel {
    private static final long serialVersionUID = -237019116383979864L;
    public static final int MODE_INSERT = 1;
    public static final int MODE_UPDATE = 2;
    private BeansToolkit beansToolkit;
    private TableModel tableModel;
    private int mode;
    private int rowIndex;
    private PropertyPage propertyPage;
    private static final Logger logger = Logger.getLogger(RowEditorPanel.class.getName());

    public RowEditorPanel() {
        this.initRowEditorPanel();
    }

    protected void initRowEditorPanel() {
        this.mode = 1;
        this.rowIndex = -1;
        this.setLayout(new GridLayout(1, 1));
        PropertyPage pp = new PropertyPage();
        this.setPropertyPage(pp);
        this.add((Component)pp);
    }

    public TableModel getTableModel() {
        return this.tableModel;
    }

    public void setTableModel(TableModel tableModel) {
        this.tableModel = tableModel;
        this.refresh();
    }

    protected void refresh() {
        logger.fine("refresh: model=" + this.tableModel);
        int cols = this.tableModel == null ? 0 : this.tableModel.getColumnCount();
        try {
            Property[] props = new Property[cols];
            for (int i = 0; i < cols; ++i) {
                String colName = this.tableModel.getColumnName(i);
                boolean nullable = true;
                Class<?> colType = this.tableModel.getColumnClass(i);
                Object colValue = null;
                if (this.rowIndex >= 0) {
                    colValue = this.tableModel.getValueAt(this.rowIndex, i);
                }
                logger.fine("refresh: colName=" + colName + ", type=" + colType + ", value=" + colValue);
                DefaultProperty prop = new DefaultProperty(colName, colType, colValue, true, true, nullable);
                props[i] = prop;
            }
            boolean checkable = false;
            if (this.mode == 2) {
                checkable = true;
            }
            this.getPropertyPage().setCheckable(checkable);
            this.getPropertyPage().setProperties(props);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int newMode) {
        if (this.mode == newMode) {
            return;
        }
        this.mode = newMode;
        this.refresh();
    }

    public int getRowIndex() {
        return this.rowIndex;
    }

    public void setRowIndex(int rowIndex) {
        this.rowIndex = rowIndex;
        this.refresh();
    }

    public BeansToolkit getBeansToolkit() {
        return this.beansToolkit;
    }

    public void setBeansToolkit(BeansToolkit beansToolkit) {
        this.beansToolkit = beansToolkit;
        this.getPropertyPage().setBeansToolkit(beansToolkit);
    }

    protected PropertyPage getPropertyPage() {
        return this.propertyPage;
    }

    protected void setPropertyPage(PropertyPage propertyPage) {
        this.propertyPage = propertyPage;
    }

    public int getPropertyCount() {
        if (this.propertyPage == null) {
            return 0;
        }
        return this.propertyPage.getPropertyCount();
    }

    public Property getPropertyAt(int index) {
        return this.propertyPage.getPropertyAt(index);
    }

    public boolean isPropertyChecked(Property p) {
        return this.propertyPage.isPropertyChecked(p);
    }
}

