/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.filetools.journal;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.StreamCorruptedException;

public class FileJournalEntry {
    public static final byte TYPE_OTHER = 0;
    public static final byte TYPE_FILE = 1;
    public static final byte TYPE_DIR = 2;
    public static final byte TYPE_LINK = 3;
    public static final byte LINK_TARGET = -82;
    public static final byte NOT_LINK = 0;
    public static final int NO_LENGTH = -1;
    public static final long NO_DATE = Long.MIN_VALUE;
    private static final int VERSION_0 = 0;
    private static final int VERSION_1 = 1;
    private static final int VERSION = 1;
    private long timestamp;
    private String path;
    private byte type;
    private boolean existing;
    private long length = -1L;
    private long lastModified = Long.MIN_VALUE;
    private long lastAccessed = Long.MIN_VALUE;
    private long creationTime = Long.MIN_VALUE;
    private String linkTarget;
    private byte[] md5Checksum;

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public byte getType() {
        return this.type;
    }

    public void setType(byte type) {
        this.type = type;
    }

    public boolean isExisting() {
        return this.existing;
    }

    public void setExisting(boolean existing) {
        this.existing = existing;
    }

    public long getLength() {
        return this.length;
    }

    public void setLength(long length) {
        this.length = length;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }

    public long getLastAccessed() {
        return this.lastAccessed;
    }

    public void setLastAccessed(long lastAccessed) {
        this.lastAccessed = lastAccessed;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(long creationTime) {
        this.creationTime = creationTime;
    }

    public String getLinkTarget() {
        return this.linkTarget;
    }

    public void setLinkTarget(String linkTarget) {
        this.linkTarget = linkTarget;
    }

    public byte[] getMd5Checksum() {
        return this.md5Checksum;
    }

    public void setMd5Checksum(byte[] md5Checksum) {
        this.md5Checksum = md5Checksum;
    }

    public boolean isFile() {
        return this.type == 1;
    }

    public boolean isDirectory() {
        return this.type == 2;
    }

    public boolean isSymbolicLink() {
        return this.type == 3;
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(1);
        out.writeLong(this.timestamp);
        out.writeUTF(this.path);
        out.writeByte(this.type);
        out.writeBoolean(this.existing);
        out.writeLong(this.length);
        out.writeLong(this.lastModified);
        out.writeLong(this.lastAccessed);
        out.writeLong(this.creationTime);
        String target = this.linkTarget;
        if (target == null) {
            out.writeByte(0);
        } else {
            out.writeByte(-82);
            out.writeUTF(target);
        }
        byte[] md5 = this.md5Checksum;
        int md5Len = md5 == null ? 0 : md5.length;
        out.writeInt(md5Len);
        if (md5Len > 0) {
            out.write(md5);
        }
    }

    public void read(DataInput in) throws IOException {
        int version = in.readInt();
        if (version < 0 || version > 1) {
            throw new StreamCorruptedException("Unsupported journal entry version: " + version);
        }
        this.timestamp = in.readLong();
        this.path = in.readUTF();
        this.type = in.readByte();
        this.existing = in.readBoolean();
        this.length = in.readLong();
        this.lastModified = in.readLong();
        long accessed = Long.MIN_VALUE;
        long created = Long.MIN_VALUE;
        String target = null;
        if (version >= 1) {
            accessed = in.readLong();
            created = in.readLong();
            byte b = in.readByte();
            if (b == -82) {
                target = in.readUTF();
            }
        }
        this.lastAccessed = accessed;
        this.creationTime = created;
        this.linkTarget = target;
        int md5Len = in.readInt();
        byte[] md5 = null;
        if (md5Len > 0) {
            md5 = new byte[md5Len];
            in.readFully(md5);
        }
        this.md5Checksum = md5;
    }

    public String toString() {
        return super.toString() + "[path=" + this.path + ", type=" + this.type + ", length=" + this.length + "]";
    }
}

