/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.filetools.journal.impl;

import com.spacekiller.filetools.journal.FileJournal;
import com.spacekiller.filetools.journal.FileJournalAction;
import com.spacekiller.filetools.journal.FileJournalCursor;
import com.spacekiller.filetools.journal.FileJournalEntry;
import com.spacekiller.filetools.journal.FileJournalFilter;
import com.spacekiller.filetools.journal.FileJournalMap;
import com.spacekiller.filetools.journal.FileJournalReplacer;
import com.spacekiller.filetools.journal.FileJournalWalker;
import com.spacekiller.filetools.journal.impl.CachedFileJournalMap;
import com.spacekiller.filetools.journal.impl.DefaultFileJournalMap;
import com.spacekiller.filetools.journal.impl.FileJournalEntrySerializer;
import com.spacekiller.filetools.journal.impl.FileJournalV2;
import com.spacekiller.filetools.journal.impl.LargeFileJournalMap;
import com.spacekiller.filetools.journal.impl.MultiFileJournalCursor;
import com.spacekiller.util.large.DefaultSerializedLargeMap;
import com.spacekiller.util.serializer.SerializerV2;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractFileJournalAction
implements FileJournalAction {
    protected Logger logger;
    protected boolean verbose;
    protected boolean debug;
    protected String journalPath;
    protected List otherJournalPaths;
    protected boolean sequential;
    protected FileJournalFilter filter;
    protected FileJournalReplacer replacer;

    protected FileJournal openFileJournal(File journalFile, boolean readOnly, boolean uncompressed) throws IOException {
        if (this.verbose) {
            String fileInfo = String.valueOf(journalFile);
            if (readOnly) {
                this.verbose("Loading journal file: " + fileInfo);
            } else {
                this.verbose("Opening journal file: " + fileInfo);
            }
        }
        FileJournalV2 journal = new FileJournalV2(journalFile, readOnly);
        journal.setUncompressed(uncompressed);
        return journal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FileJournalCursor createFileJournalCursor(boolean journalFileMustExist) throws IOException {
        LinkedList<FileJournal> journalList = new LinkedList<FileJournal>();
        boolean success = false;
        try {
            FileJournal fileJournal;
            boolean readOnly = true;
            boolean uncompressed = false;
            if (this.otherJournalPaths != null) {
                for (String otherPath : this.otherJournalPaths) {
                    File otherFile = new File(otherPath);
                    FileJournal fileJournal2 = this.openFileJournal(otherFile, readOnly, uncompressed);
                    if (fileJournal2 == null) continue;
                    journalList.add(fileJournal2);
                }
            }
            File journalFile = new File(this.journalPath);
            if ((journalFileMustExist || journalFile.exists()) && (fileJournal = this.openFileJournal(journalFile, readOnly, uncompressed)) != null) {
                journalList.add(fileJournal);
            }
            FileJournal[] fileJournals = journalList.toArray(new FileJournal[journalList.size()]);
            MultiFileJournalCursor cursor = new MultiFileJournalCursor(fileJournals, this.sequential);
            success = true;
            MultiFileJournalCursor multiFileJournalCursor = cursor;
            return multiFileJournalCursor;
        }
        finally {
            int num;
            if (!success && (num = journalList.size()) > 0) {
                FileJournal[] fileJournals = journalList.toArray(new FileJournal[num]);
                for (int i = 0; i < num; ++i) {
                    try {
                        FileJournal fileJournal = fileJournals[i];
                        fileJournal.close();
                        continue;
                    }
                    catch (Exception e) {
                        this.error(e);
                    }
                }
            }
        }
    }

    protected long walkFileJournal(FileJournalCursor cursor, FileJournalWalker walker) throws Exception {
        long count = 0L;
        while (cursor.hasNext()) {
            ++count;
            FileJournalEntry entry = cursor.nextEntry();
            walker.walk(entry);
        }
        return count;
    }

    protected void info(String s) {
        Logger l = this.logger;
        if (l != null) {
            l.info(s);
        } else {
            System.out.println(s);
        }
    }

    protected void verbose(String s) {
        Logger l = this.logger;
        if (l != null) {
            l.fine(s);
        } else {
            System.out.println(s);
        }
    }

    protected void debug(String s) {
        Logger l = this.logger;
        if (l != null) {
            l.finer(s);
        } else {
            System.out.println(s);
        }
    }

    protected void warning(String s) {
        Logger l = this.logger;
        if (l != null) {
            l.warning(s);
        } else {
            System.out.println(s);
        }
    }

    protected void error(String s) {
        Logger l = this.logger;
        if (l != null) {
            l.severe(s);
        } else {
            System.err.println(s);
        }
    }

    protected void error(Throwable e) {
        Logger l = this.logger;
        if (l != null) {
            l.log(Level.SEVERE, e.getMessage(), e);
        } else {
            e.printStackTrace(System.err);
        }
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public String getJournalPath() {
        return this.journalPath;
    }

    public void setJournalPath(String journalPath) {
        this.journalPath = journalPath;
    }

    public List getOtherJournalPaths() {
        return this.otherJournalPaths;
    }

    public void setOtherJournalPaths(List otherJournalPaths) {
        this.otherJournalPaths = otherJournalPaths;
    }

    public boolean isSequential() {
        return this.sequential;
    }

    public void setSequential(boolean sequential) {
        this.sequential = sequential;
    }

    public FileJournalFilter getFilter() {
        return this.filter;
    }

    public void setFilter(FileJournalFilter filter) {
        this.filter = filter;
    }

    public FileJournalReplacer getReplacer() {
        return this.replacer;
    }

    public void setReplacer(FileJournalReplacer replacer) {
        this.replacer = replacer;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    protected FileJournalMap createFileJournalMap() throws IOException {
        FileJournalMap journalMap = null;
        boolean useDefaultMap = true;
        boolean useCachedMap = false;
        if (useDefaultMap) {
            HashMap map = new HashMap();
            journalMap = new DefaultFileJournalMap(map);
            return journalMap;
        }
        SerializerV2 keySerializer = new SerializerV2();
        FileJournalEntrySerializer valueSerializer = new FileJournalEntrySerializer();
        DefaultSerializedLargeMap largeMap = new DefaultSerializedLargeMap(keySerializer, valueSerializer);
        LargeFileJournalMap largeFileJournalMap = new LargeFileJournalMap(largeMap);
        journalMap = largeFileJournalMap;
        if (useCachedMap) {
            int cacheLimit = 20000;
            CachedFileJournalMap cachedMap = new CachedFileJournalMap(journalMap, cacheLimit);
            journalMap = cachedMap;
        }
        return journalMap;
    }

    protected FileJournalMap createFileJournalTreeMap() throws IOException {
        TreeMap map = new TreeMap();
        return new DefaultFileJournalMap(map);
    }
}

