/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.filetools.journal.impl;

import com.spacekiller.filetools.journal.FileJournal;
import com.spacekiller.filetools.journal.FileJournalCursor;
import com.spacekiller.filetools.journal.FileJournalEntry;
import com.spacekiller.filetools.journal.FileJournalFilter;
import com.spacekiller.filetools.journal.FileJournalMap;
import com.spacekiller.filetools.journal.FileJournalReplacer;
import com.spacekiller.filetools.journal.FileJournalScanner;
import com.spacekiller.filetools.journal.impl.FileJournalComparator;
import com.spacekiller.filetools.journal.impl.FileJournalUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractFileJournalScanner
implements FileJournalScanner {
    protected static final String MD5_ALGORITHM = "MD5";
    protected static final int MD5_LENGTH = 16;
    protected Logger logger;
    private FileJournal journal;
    protected boolean verbose;
    protected boolean debug;
    protected boolean dryRun;
    protected boolean followSymlinks;
    protected boolean ignoreMissing;
    protected boolean ignoreErrors;
    protected FileJournalFilter scanFilter;
    protected FileJournalFilter includeFilter;
    protected FileJournalReplacer replacer;
    protected FileJournalComparator comparator;
    private int flushThreshold = 100;
    private int md5BufferSize = 0x1000000;
    private byte[] md5Buffer;
    private MessageDigest md5Digest;
    protected FileJournalMap latestEntryMap;
    private List newEntryList = new LinkedList();
    private long insertCount;
    private long updateCount;
    private long removeCount;

    public AbstractFileJournalScanner() throws Exception {
        this.md5Buffer = new byte[this.md5BufferSize];
        this.md5Digest = MessageDigest.getInstance(MD5_ALGORITHM);
    }

    protected void appendEntry(FileJournalEntry entry, FileJournalEntry old) throws IOException {
        if (entry.isExisting()) {
            if (old != null && old.isExisting()) {
                ++this.updateCount;
            } else {
                ++this.insertCount;
            }
        } else {
            ++this.removeCount;
        }
        if (this.dryRun) {
            return;
        }
        this.newEntryList.add(entry);
        if (this.newEntryList.size() >= this.flushThreshold) {
            this.flushNewEntries();
        }
    }

    protected void flushNewEntries() throws IOException {
        int count = this.newEntryList.size();
        if (count < 1) {
            return;
        }
        if (this.verbose) {
            this.verbose("Flushing " + count + " entries.");
        }
        for (FileJournalEntry entry : this.newEntryList) {
            this.journal.appendEntry(entry);
        }
        this.newEntryList.clear();
        this.journal.flush();
    }

    protected long timestamp() {
        return System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] computeMd5Checksum(File file, long fileLen) throws IOException {
        byte[] buf;
        byte[] byArray = buf = this.md5Buffer;
        synchronized (buf) {
            // ** MonitorExit[var5_4] (shouldn't be in output)
            return this.computeMd5Checksum(file, fileLen, buf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] computeMd5Checksum(File file, long fileLen, byte[] buf) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        try {
            int n;
            this.md5Digest.reset();
            long total = 0L;
            while ((n = fis.read(buf)) >= 0) {
                this.md5Digest.update(buf, 0, n);
                if ((total += (long)n) <= fileLen) continue;
            }
            if (total != fileLen) {
                byte[] byArray = null;
                return byArray;
            }
            byte[] md5 = this.md5Digest.digest();
            if (md5.length != 16) {
                throw new IllegalStateException("Invalid MD5 checksum length: " + md5.length + " != " + 16);
            }
            byte[] byArray = md5;
            return byArray;
        }
        finally {
            fis.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long checkMissingFiles(Set done) throws IOException {
        FileJournalReplacer fjr = this.replacer;
        if (fjr != null) {
            HashSet<String> doneReplaced = new HashSet<String>();
            for (String path : done) {
                path = fjr.replace(path);
                doneReplaced.add(path);
            }
            done = doneReplaced;
        }
        long missingCount = 0L;
        FileJournalCursor latestCursor = this.latestEntryMap.createCursor();
        try {
            while (latestCursor.hasNext()) {
                String path;
                FileJournalEntry entry = latestCursor.nextEntry();
                if (!entry.isExisting() || (path = entry.getPath()) == null || path.length() < 1 || done.contains(path)) continue;
                FileJournalFilter fjf = this.includeFilter;
                if (fjf != null && !fjf.accept(path)) {
                    if (!this.debug) continue;
                    this.debug("Excluded: " + path);
                    continue;
                }
                long timestamp = this.timestamp();
                File file = new File(path);
                if (file.exists()) continue;
                entry.setTimestamp(timestamp);
                entry.setExisting(false);
                this.info(FileJournalUtil.formatEntry(entry, null));
                this.appendEntry(entry, null);
                ++missingCount;
            }
        }
        finally {
            latestCursor.close();
        }
        return missingCount;
    }

    protected void mergeEntry(FileJournalEntry temp, FileJournalEntry old) {
        if (old == null) {
            return;
        }
        long time = temp.getCreationTime();
        long oldTime = old.getCreationTime();
        if (time == Long.MIN_VALUE || oldTime < time && oldTime != Long.MIN_VALUE && old.isExisting()) {
            temp.setCreationTime(oldTime);
        }
        time = temp.getLastAccessed();
        oldTime = old.getLastAccessed();
        if (time == Long.MIN_VALUE || oldTime > time && oldTime != Long.MIN_VALUE && old.isExisting()) {
            temp.setLastAccessed(oldTime);
        }
    }

    protected void info(String s) {
        Logger l = this.logger;
        if (l != null) {
            l.info(s);
        } else {
            System.out.println(s);
        }
    }

    protected void verbose(String s) {
        Logger l = this.logger;
        if (l != null) {
            l.fine(s);
        } else {
            System.out.println(s);
        }
    }

    protected void debug(String s) {
        Logger l = this.logger;
        if (l != null) {
            l.finer(s);
        } else {
            System.out.println(s);
        }
    }

    protected void error(String s) {
        Logger l = this.logger;
        if (l != null) {
            l.severe(s);
        } else {
            System.err.println(s);
        }
    }

    protected void error(Throwable e) {
        if (e == null) {
            return;
        }
        Logger l = this.logger;
        if (l != null) {
            l.severe("Error: " + e);
            if (this.debug) {
                l.log(Level.SEVERE, e.getMessage(), e);
            }
        } else {
            System.err.println("Error: " + e);
            if (this.debug) {
                e.printStackTrace(System.err);
            }
        }
    }

    public boolean isIgnoreMissing() {
        return this.ignoreMissing;
    }

    public void setIgnoreMissing(boolean ignoreMissing) {
        this.ignoreMissing = ignoreMissing;
    }

    public boolean isIgnoreErrors() {
        return this.ignoreErrors;
    }

    public void setIgnoreErrors(boolean ignoreErrors) {
        this.ignoreErrors = ignoreErrors;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public boolean isDryRun() {
        return this.dryRun;
    }

    public void setDryRun(boolean dryRun) {
        this.dryRun = dryRun;
    }

    public boolean isFollowSymlinks() {
        return this.followSymlinks;
    }

    public void setFollowSymlinks(boolean followSymlinks) {
        this.followSymlinks = followSymlinks;
    }

    public int getFlushThreshold() {
        return this.flushThreshold;
    }

    public void setFlushThreshold(int flushThreshold) {
        this.flushThreshold = flushThreshold;
    }

    @Override
    public FileJournalFilter getScanFilter() {
        return this.scanFilter;
    }

    @Override
    public void setScanFilter(FileJournalFilter scanFilter) {
        this.scanFilter = scanFilter;
    }

    @Override
    public FileJournalFilter getIncludeFilter() {
        return this.includeFilter;
    }

    @Override
    public void setIncludeFilter(FileJournalFilter filter) {
        this.includeFilter = filter;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public long getInsertCount() {
        return this.insertCount;
    }

    protected void setInsertCount(long insertCount) {
        this.insertCount = insertCount;
    }

    public long getUpdateCount() {
        return this.updateCount;
    }

    protected void setUpdateCount(long updateCount) {
        this.updateCount = updateCount;
    }

    public long getRemoveCount() {
        return this.removeCount;
    }

    protected void setRemoveCount(long removeCount) {
        this.removeCount = removeCount;
    }

    @Override
    public FileJournalMap getLatestEntryMap() {
        return this.latestEntryMap;
    }

    @Override
    public void setLatestEntryMap(FileJournalMap latestEntryMap) {
        this.latestEntryMap = latestEntryMap;
    }

    @Override
    public FileJournal getJournal() {
        return this.journal;
    }

    @Override
    public void setJournal(FileJournal journal) {
        this.journal = journal;
    }

    public FileJournalReplacer getReplacer() {
        return this.replacer;
    }

    public void setReplacer(FileJournalReplacer replacer) {
        this.replacer = replacer;
    }

    public FileJournalComparator getComparator() {
        return this.comparator;
    }

    public void setComparator(FileJournalComparator comparator) {
        this.comparator = comparator;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }
}

