/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.filetools.journal.impl;

import com.spacekiller.filetools.journal.FileJournalEntry;
import com.spacekiller.filetools.journal.FileJournalFilter;
import com.spacekiller.filetools.journal.FileJournalReplacer;
import com.spacekiller.filetools.journal.FileJournalWalker;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractFileJournalWalker
implements FileJournalWalker {
    protected FileJournalFilter filter;
    protected FileJournalReplacer replacer;
    protected Date startDate;
    protected long startDateMillis;
    protected Date untilDate;
    protected long untilDateMillis;
    protected Map latestEntryMap = new HashMap();
    protected long walkCount;

    public AbstractFileJournalWalker() {
        this.setStartDate(null);
        this.setUntilDate(null);
    }

    @Override
    public void walk(FileJournalEntry entry) throws Exception {
        String replaced;
        long time = entry.getTimestamp();
        if (time < this.startDateMillis) {
            return;
        }
        if (time > this.untilDateMillis) {
            return;
        }
        String path = entry.getPath();
        FileJournalFilter fjf = this.filter;
        if (fjf != null && !fjf.accept(path)) {
            return;
        }
        FileJournalReplacer fjr = this.replacer;
        if (fjr != null && (replaced = fjr.replace(path)) != path) {
            path = replaced;
            entry.setPath(path);
        }
        ++this.walkCount;
        FileJournalEntry old = this.latestEntryMap.put(path, entry);
        this.walkEntry(entry, old);
    }

    protected abstract void walkEntry(FileJournalEntry var1, FileJournalEntry var2) throws Exception;

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
        long millis = Long.MIN_VALUE;
        if (startDate != null) {
            millis = startDate.getTime();
        }
        this.startDateMillis = millis;
    }

    public Date getUntilDate() {
        return this.untilDate;
    }

    public void setUntilDate(Date untilDate) {
        this.untilDate = untilDate;
        long millis = Long.MAX_VALUE;
        if (untilDate != null) {
            millis = untilDate.getTime();
        }
        this.untilDateMillis = millis;
    }

    public FileJournalFilter getFilter() {
        return this.filter;
    }

    public void setFilter(FileJournalFilter filter) {
        this.filter = filter;
    }

    public long getWalkCount() {
        return this.walkCount;
    }

    protected void setWalkCount(long walkCount) {
        this.walkCount = walkCount;
    }

    public FileJournalReplacer getReplacer() {
        return this.replacer;
    }

    public void setReplacer(FileJournalReplacer replacer) {
        this.replacer = replacer;
    }
}

