/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.filetools.journal.impl;

import com.spacekiller.filetools.journal.FileJournal;
import com.spacekiller.filetools.journal.FileJournalCursor;
import com.spacekiller.filetools.journal.FileJournalEntry;
import com.spacekiller.filetools.journal.FileJournalMap;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class CachedFileJournalMap
implements FileJournalMap {
    private static final byte STATE_CACHED = 0;
    private static final byte STATE_INSERT = 1;
    private static final byte STATE_UPDATE = 2;
    private static final byte STATE_REMOVE = 3;
    protected FileJournalMap map;
    protected boolean dirty;
    protected Map cache;
    protected int cacheLimit;
    protected long deltaSize;

    public CachedFileJournalMap(FileJournalMap map, int cacheLimit) throws IOException {
        this.map = map;
        this.cacheLimit = cacheLimit;
        this.cache = new HashMap();
    }

    @Override
    public void close() throws IOException {
        if (this.map != null) {
            this.map.close();
            this.map = null;
        }
        this.cache = null;
        this.deltaSize = 0L;
    }

    @Override
    public long size() {
        return this.map.size() + this.deltaSize;
    }

    @Override
    public FileJournalEntry get(String key) throws IOException {
        CacheEntry ce = (CacheEntry)this.cache.get(key);
        if (ce != null) {
            return ce.entry;
        }
        FileJournalEntry entry = this.map.get(key);
        if (entry != null) {
            ce = new CacheEntry();
            ce.entry = entry;
            ce.state = 0;
            this.cache.put(key, ce);
            this.checkCacheLimit();
        }
        return entry;
    }

    @Override
    public FileJournalEntry put(String key, FileJournalEntry entry) throws IOException {
        if (key == null) {
            throw new NullPointerException("key must not be null");
        }
        if (entry == null) {
            throw new NullPointerException("entry must not be null");
        }
        CacheEntry ce = (CacheEntry)this.cache.get(key);
        if (ce != null) {
            switch (ce.state) {
                case 0: {
                    FileJournalEntry prev = ce.entry;
                    ce.entry = entry;
                    ce.state = (byte)2;
                    this.dirty = true;
                    return prev;
                }
                case 1: {
                    FileJournalEntry prev = ce.entry;
                    ce.entry = entry;
                    return prev;
                }
                case 2: {
                    FileJournalEntry prev = ce.entry;
                    ce.entry = entry;
                    return prev;
                }
                case 3: {
                    ce.entry = entry;
                    ce.state = (byte)2;
                    ++this.deltaSize;
                    return null;
                }
            }
            return null;
        }
        FileJournalEntry prev = this.map.get(key);
        if (prev != null) {
            ce = new CacheEntry();
            ce.entry = entry;
            ce.state = (byte)2;
            this.cache.put(key, ce);
            this.dirty = true;
            this.checkCacheLimit();
            return prev;
        }
        ce = new CacheEntry();
        ce.entry = entry;
        ce.state = 1;
        this.cache.put(key, ce);
        ++this.deltaSize;
        this.dirty = true;
        this.checkCacheLimit();
        return null;
    }

    @Override
    public FileJournalEntry remove(String key) throws IOException {
        if (key == null) {
            return null;
        }
        CacheEntry ce = (CacheEntry)this.cache.get(key);
        if (ce != null) {
            switch (ce.state) {
                case 3: {
                    return null;
                }
                case 1: {
                    this.cache.remove(key);
                    --this.deltaSize;
                    return ce.entry;
                }
            }
            FileJournalEntry prev = ce.entry;
            ce.entry = null;
            ce.state = (byte)3;
            --this.deltaSize;
            this.dirty = true;
            return prev;
        }
        FileJournalEntry prev = this.map.get(key);
        if (prev == null) {
            return null;
        }
        ce = new CacheEntry();
        ce.state = (byte)3;
        this.cache.put(key, ce);
        --this.deltaSize;
        this.dirty = true;
        this.checkCacheLimit();
        return prev;
    }

    protected void checkCacheLimit() throws IOException {
        if (this.cache.size() < this.cacheLimit) {
            return;
        }
        this.drain();
    }

    protected synchronized void drain() throws IOException {
        this.flush();
        Iterator iter = this.cache.entrySet().iterator();
        while (iter.hasNext()) {
            iter.next();
            if (!iter.hasNext()) continue;
            iter.next();
            iter.remove();
        }
    }

    protected synchronized void flush() throws IOException {
        if (!this.dirty) {
            return;
        }
        Iterator iter = this.cache.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry me = iter.next();
            CacheEntry ce = (CacheEntry)me.getValue();
            switch (ce.state) {
                case 1: {
                    String key = (String)me.getKey();
                    this.map.put(key, ce.entry);
                    ce.state = 0;
                    --this.deltaSize;
                    break;
                }
                case 2: {
                    String key = (String)me.getKey();
                    this.map.put(key, ce.entry);
                    ce.state = 0;
                    break;
                }
                case 3: {
                    String key = (String)me.getKey();
                    this.map.remove(key);
                    iter.remove();
                    ++this.deltaSize;
                }
            }
        }
        this.deltaSize = 0L;
        this.dirty = false;
    }

    @Override
    public FileJournalCursor createCursor() throws IOException {
        this.flush();
        return new CursorImpl();
    }

    protected class CursorImpl
    implements FileJournalCursor {
        private FileJournalEntry entry;
        private FileJournalEntry next;
        private Iterator iter;
        private FileJournalCursor curs;

        public CursorImpl() throws IOException {
            this.iter = CachedFileJournalMap.this.cache.values().iterator();
            this.curs = CachedFileJournalMap.this.map.createCursor();
            this.scanNext();
        }

        @Override
        public void close() throws IOException {
            if (this.curs != null) {
                this.curs.close();
                this.curs = null;
            }
            this.iter = null;
            this.entry = null;
            this.next = null;
        }

        @Override
        public boolean hasNext() throws IOException {
            return this.next != null;
        }

        @Override
        public FileJournalEntry nextEntry() throws IOException {
            this.entry = this.next;
            this.scanNext();
            return this.entry;
        }

        protected void scanNext() throws IOException {
            CacheEntry ce;
            while (this.iter.hasNext()) {
                ce = (CacheEntry)this.iter.next();
                if (ce.state == 3) continue;
                this.next = ce.entry;
                return;
            }
            while (this.curs.hasNext()) {
                String key;
                FileJournalEntry je = this.curs.nextEntry();
                if (je == null || (ce = (CacheEntry)CachedFileJournalMap.this.cache.get(key = je.getPath())) != null) continue;
                this.next = je;
                return;
            }
            this.next = null;
        }

        @Override
        public FileJournalEntry getEntry() {
            return this.entry;
        }

        @Override
        public FileJournal getJournal() {
            throw new UnsupportedOperationException();
        }
    }

    protected static class CacheEntry {
        protected FileJournalEntry entry;
        protected byte state;

        protected CacheEntry() {
        }
    }
}

