/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.filetools.journal.impl;

import com.spacekiller.filetools.journal.FileJournal;
import com.spacekiller.filetools.journal.FileJournalCursor;
import com.spacekiller.filetools.journal.FileJournalEntry;
import com.spacekiller.filetools.journal.FileJournalMap;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;

public class DefaultFileJournalMap
implements FileJournalMap {
    protected Map map;

    public DefaultFileJournalMap(Map map) {
        this.map = map;
    }

    @Override
    public void close() throws IOException {
        this.map = null;
    }

    @Override
    public long size() {
        return this.map.size();
    }

    @Override
    public FileJournalEntry get(String key) throws IOException {
        return (FileJournalEntry)this.map.get(key);
    }

    @Override
    public FileJournalEntry put(String key, FileJournalEntry entry) throws IOException {
        return this.map.put(key, entry);
    }

    @Override
    public FileJournalEntry remove(String key) throws IOException {
        return (FileJournalEntry)this.map.remove(key);
    }

    @Override
    public FileJournalCursor createCursor() throws IOException {
        return new CursorImpl();
    }

    protected class CursorImpl
    implements FileJournalCursor {
        private Iterator iter;
        private FileJournalEntry entry;

        public CursorImpl() throws IOException {
            this.iter = DefaultFileJournalMap.this.map.entrySet().iterator();
        }

        @Override
        public void close() throws IOException {
            this.iter = null;
        }

        @Override
        public boolean hasNext() throws IOException {
            return this.iter.hasNext();
        }

        @Override
        public FileJournalEntry nextEntry() throws IOException {
            Map.Entry me = (Map.Entry)this.iter.next();
            this.entry = (FileJournalEntry)me.getValue();
            return this.entry;
        }

        @Override
        public FileJournalEntry getEntry() {
            return this.entry;
        }

        @Override
        public FileJournal getJournal() {
            throw new UnsupportedOperationException();
        }
    }
}

