/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.filetools.journal.impl;

import com.spacekiller.filetools.journal.FileJournalCursor;
import com.spacekiller.filetools.journal.FileJournalEntry;
import com.spacekiller.filetools.journal.FileJournalFilter;
import com.spacekiller.filetools.journal.FileJournalMap;
import com.spacekiller.filetools.journal.impl.BaseFileJournalAction;
import com.spacekiller.filetools.journal.impl.FileJournalUtil;
import com.spacekiller.filetools.journal.impl.LatestFileJournalWalker;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

public class DuplicatesFileJournalAction
extends BaseFileJournalAction {
    private FileJournalFilter removeFilter;
    private boolean unix = true;
    private boolean windows;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute() throws Exception {
        boolean valid = true;
        if (this.journalPath == null) {
            valid = false;
            this.error("Missing argument: [journalFilePath]");
        }
        if (!valid) {
            return false;
        }
        if (this.verbose) {
            this.verbose("Loading latest journal entries...");
        }
        FileJournalMap latestEntryMap = this.createFileJournalMap();
        try {
            List<FileJournalEntry> list;
            DupKey key;
            boolean compareTimestamp = !this.sequential;
            LatestFileJournalWalker walker = new LatestFileJournalWalker(compareTimestamp, latestEntryMap);
            walker.setStartDate(this.startDate);
            walker.setUntilDate(this.untilDate);
            walker.setFilter(this.filter);
            walker.setReplacer(this.replacer);
            boolean journalFileMustExist = true;
            FileJournalCursor cursor = this.createFileJournalCursor(journalFileMustExist);
            try {
                this.walkFileJournal(cursor, walker);
            }
            finally {
                cursor.close();
            }
            if (this.verbose) {
                this.verbose("Number of walked journal entries: " + walker.getWalkCount());
                this.verbose("Number of latest journal entries: " + latestEntryMap.size());
            }
            if (this.verbose) {
                this.verbose("Searching journal entries for duplicate files...");
            }
            long emptyCount = 0L;
            HashMap<DupKey, FileJournalEntry> checkMap = new HashMap<DupKey, FileJournalEntry>();
            HashMap<DupKey, LinkedList<FileJournalEntry>> dupMap = new HashMap<DupKey, LinkedList<FileJournalEntry>>();
            FileJournalCursor latestCursor = latestEntryMap.createCursor();
            try {
                while (latestCursor.hasNext()) {
                    long len;
                    FileJournalEntry entry = latestCursor.nextEntry();
                    if (!entry.isExisting() || (len = entry.getLength()) < 0L) continue;
                    if (len == 0L) {
                        ++emptyCount;
                        continue;
                    }
                    byte[] md5 = entry.getMd5Checksum();
                    if (md5 == null) continue;
                    key = new DupKey(len, md5);
                    FileJournalEntry val = (FileJournalEntry)checkMap.get(key);
                    if (val == null) {
                        checkMap.put(key, entry);
                        continue;
                    }
                    list = (List)dupMap.get(key);
                    if (list == null) {
                        list = new LinkedList<FileJournalEntry>();
                        list.add(val);
                        dupMap.put(key, (LinkedList<FileJournalEntry>)list);
                    }
                    list.add(entry);
                }
            }
            finally {
                latestCursor.close();
            }
            if (this.verbose) {
                this.verbose("Number of empty files: " + emptyCount);
            }
            if (this.verbose) {
                this.verbose("Number of duplicates: " + dupMap.size());
            }
            int index = 0;
            ArrayList removeList = new ArrayList();
            LinkedList commandList = new LinkedList();
            for (Map.Entry me : dupMap.entrySet()) {
                key = (DupKey)me.getKey();
                list = (LinkedList<FileJournalEntry>)me.getValue();
                this.findDuplicates(index, key, list, removeList, commandList);
                ++index;
            }
            if (this.verbose && this.removeFilter != null) {
                int removeCount = commandList.size();
                this.verbose("Number of remove commands: " + removeCount);
            }
            if (this.removeFilter != null) {
                TreeSet sortedCommands = new TreeSet();
                sortedCommands.addAll(commandList);
                for (String command : sortedCommands) {
                    this.info(command);
                }
            }
        }
        finally {
            latestEntryMap.close();
        }
        return true;
    }

    protected void findDuplicates(int index, DupKey key, List list, List removeList, List commandList) {
        removeList.clear();
        if (this.removeFilter == null) {
            this.info("Duplicates #" + index + ":");
        }
        boolean others = false;
        for (FileJournalEntry entry : list) {
            if (this.removeFilter == null) {
                this.info("Duplicate: " + entry.getPath());
                continue;
            }
            if (this.removeFilter.accept(entry.getPath())) {
                removeList.add(entry);
                continue;
            }
            others = true;
        }
        if (this.removeFilter != null && !removeList.isEmpty() && others) {
            for (FileJournalEntry entry : removeList) {
                String dirPath;
                String command = null;
                if (this.unix) {
                    dirPath = entry.getPath();
                    if (dirPath != null && dirPath.length() > 0) {
                        dirPath = dirPath.replace('\\', '/');
                        command = "rm " + FileJournalUtil.formatEscapePath(dirPath);
                    }
                } else if (this.windows && (dirPath = entry.getPath()) != null && dirPath.length() > 0) {
                    dirPath = dirPath.replace('/', '\\');
                    command = "erase " + FileJournalUtil.formatEscapePath(dirPath);
                }
                if (command == null) continue;
                commandList.add(command);
            }
        } else {
            removeList.clear();
        }
    }

    public FileJournalFilter getRemoveFilter() {
        return this.removeFilter;
    }

    public void setRemoveFilter(FileJournalFilter removeFilter) {
        this.removeFilter = removeFilter;
    }

    public boolean isWindows() {
        return this.windows;
    }

    public void setWindows(boolean windows) {
        this.windows = windows;
        if (windows) {
            this.unix = false;
        }
    }

    public boolean isUnix() {
        return this.unix;
    }

    public void setUnix(boolean unix) {
        this.unix = unix;
        if (unix) {
            this.windows = false;
        }
    }

    protected static class DupKey {
        private final long len;
        private final byte[] md5;

        public DupKey(long len, byte[] md5) {
            this.len = len;
            this.md5 = md5;
        }

        public boolean equals(Object obj) {
            if (obj != null && obj instanceof DupKey) {
                DupKey dup = (DupKey)obj;
                if (dup.len != this.len) {
                    return false;
                }
                return Arrays.equals(dup.md5, this.md5);
            }
            return false;
        }

        public int hashCode() {
            return DupKey.hashCode(this.md5) + DupKey.hashCode(this.len);
        }

        private static int hashCode(long value) {
            return (int)(value ^ value >>> 32);
        }

        private static int hashCode(byte[] a) {
            if (a == null) {
                return 0;
            }
            int result = 1;
            int len = a.length;
            for (int i = 0; i < len; ++i) {
                result = 31 * result + a[i];
            }
            return result;
        }
    }
}

