/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.filetools.journal.impl;

import com.spacekiller.filetools.journal.FileJournal;
import com.spacekiller.filetools.journal.FileJournalCursor;
import com.spacekiller.filetools.journal.impl.BaseFileJournalAction;
import com.spacekiller.filetools.journal.impl.ExportFileJournalWalker;
import java.io.File;

public class ExportFileJournalAction
extends BaseFileJournalAction {
    private String exportPath;
    private boolean uncompressed;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute() throws Exception {
        boolean valid = true;
        if (this.journalPath == null) {
            valid = false;
            this.error("Missing argument: [sourceJournalPath]");
        }
        if (this.exportPath == null) {
            valid = false;
            this.error("Missing argument: [targetJournalPath]");
        }
        if (!valid) {
            return false;
        }
        if (this.verbose) {
            this.verbose("Export: " + this.journalPath);
            this.verbose("Target: " + this.exportPath);
        }
        ExportFileJournalWalker walker = new ExportFileJournalWalker();
        walker.setStartDate(this.startDate);
        walker.setUntilDate(this.untilDate);
        walker.setFilter(this.filter);
        walker.setReplacer(this.replacer);
        boolean journalFileMustExist = true;
        FileJournalCursor cursor = this.createFileJournalCursor(journalFileMustExist);
        try {
            File targetFile = new File(this.exportPath);
            boolean readOnly = false;
            FileJournal targetJournal = this.openFileJournal(targetFile, readOnly, this.uncompressed);
            try {
                walker.setTargetJournal(targetJournal);
                this.walkFileJournal(cursor, walker);
            }
            finally {
                targetJournal.close();
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            this.error(e);
            boolean bl = false;
            return bl;
        }
        finally {
            cursor.close();
            if (this.verbose) {
                this.verbose("Number of walked journal entries: " + walker.getWalkCount());
            }
        }
    }

    public String getExportPath() {
        return this.exportPath;
    }

    public void setExportPath(String exportPath) {
        this.exportPath = exportPath;
    }

    public boolean isUncompressed() {
        return this.uncompressed;
    }

    public void setUncompressed(boolean uncompressed) {
        this.uncompressed = uncompressed;
    }
}

