/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.filetools.journal.impl;

import com.spacekiller.filetools.journal.FileJournalEntry;
import com.spacekiller.filetools.journal.impl.FileJournalUtil;
import java.text.DateFormat;
import java.util.Arrays;

public class FileJournalComparator {
    public static final int REASON_NONE = 0;
    public static final int REASON_NEW = 1;
    public static final int REASON_LENGTH = 2;
    public static final int REASON_EXISTING = 3;
    public static final int REASON_TYPE = 4;
    public static final int REASON_LAST_MODIFIED = 5;
    public static final int REASON_MD5_CHECKSUM = 6;
    private boolean sizeOnly;
    private boolean sumOnly;
    private boolean checksum;

    public int compareEntry(FileJournalEntry temp, FileJournalEntry old) {
        boolean lastmod;
        if (old == null) {
            return 1;
        }
        if (temp.isExisting() != old.isExisting()) {
            return 3;
        }
        if (temp.getType() != old.getType()) {
            return 4;
        }
        if (temp.getLength() != old.getLength()) {
            return 2;
        }
        if (this.sizeOnly) {
            return 0;
        }
        boolean bl = lastmod = temp.getLastModified() != old.getLastModified();
        if (lastmod && !this.sumOnly) {
            return 5;
        }
        if (this.checksum || lastmod && this.sumOnly) {
            byte[] newMd5 = temp.getMd5Checksum();
            byte[] oldMd5 = old.getMd5Checksum();
            if (newMd5 == null) {
                if (oldMd5 != null) {
                    return 6;
                }
            } else {
                if (oldMd5 == null) {
                    return 6;
                }
                if (!Arrays.equals(newMd5, oldMd5)) {
                    return 6;
                }
            }
        }
        return 0;
    }

    public String getReasonString(int reason, FileJournalEntry temp, FileJournalEntry old) {
        return this.getReasonString(reason, temp, old, null);
    }

    public String getReasonString(int reason, FileJournalEntry temp, FileJournalEntry old, DateFormat format) {
        switch (reason) {
            case 0: {
                return "NONE";
            }
            case 1: {
                return "NEW";
            }
            case 3: {
                Boolean newExisting = temp == null ? null : Boolean.valueOf(temp.isExisting());
                Boolean oldExisting = old == null ? null : Boolean.valueOf(old.isExisting());
                return "EXISTING " + newExisting + " != " + oldExisting;
            }
            case 4: {
                String newType = temp == null ? null : FileJournalUtil.formatType(temp.getType());
                String oldType = old == null ? null : FileJournalUtil.formatType(old.getType());
                return "TYPE " + newType + " != " + oldType;
            }
            case 2: {
                String newLength = temp == null ? null : Long.toString(temp.getLength());
                String oldLength = old == null ? null : Long.toString(old.getLength());
                return "LENGTH " + newLength + " != " + oldLength;
            }
            case 5: {
                String newMod = null;
                if (temp != null) {
                    long lastMod = temp.getLastModified();
                    newMod = format == null ? String.valueOf(lastMod) : FileJournalUtil.formatTimestamp(lastMod, format);
                }
                String oldMod = null;
                if (old != null) {
                    long lastMod = old.getLastModified();
                    oldMod = format == null ? String.valueOf(lastMod) : FileJournalUtil.formatTimestamp(lastMod, format);
                }
                return "LAST_MODIFIED " + newMod + " != " + oldMod;
            }
            case 6: {
                byte[] md5;
                byte[] md52;
                String newChk = null;
                if (temp != null && (md52 = temp.getMd5Checksum()) != null) {
                    char[] chars = new char[md52.length * 2];
                    FileJournalUtil.formatHex(md52, chars, 0);
                    newChk = new String(chars);
                }
                String oldChk = null;
                if (old != null && (md5 = old.getMd5Checksum()) != null) {
                    char[] chars = new char[md5.length * 2];
                    FileJournalUtil.formatHex(md5, chars, 0);
                    oldChk = new String(chars);
                }
                return "MD5_CHECKSUM " + newChk + " != " + oldChk;
            }
        }
        return "#" + reason;
    }

    public boolean isSizeOnly() {
        return this.sizeOnly;
    }

    public void setSizeOnly(boolean sizeOnly) {
        this.sizeOnly = sizeOnly;
    }

    public boolean isSumOnly() {
        return this.sumOnly;
    }

    public void setSumOnly(boolean sumOnly) {
        this.sumOnly = sumOnly;
    }

    public boolean isChecksum() {
        return this.checksum;
    }

    public void setChecksum(boolean checksum) {
        this.checksum = checksum;
    }
}

