/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.filetools.journal.impl;

import com.spacekiller.filetools.journal.FileJournalEntry;
import java.text.DateFormat;
import java.util.Date;

public class FileJournalUtil {
    private static final String HEX_STRING = "0123456789abcdef";
    private static final char[] HEX_CHARS = "0123456789abcdef".toCharArray();

    private FileJournalUtil() {
    }

    public static void formatHex(byte[] sum, char[] dst, int idx) {
        for (byte b : sum) {
            dst[idx++] = HEX_CHARS[(b & 0xF0) >> 4];
            dst[idx++] = HEX_CHARS[b & 0xF];
        }
    }

    public static String formatTimestamp(Date date, DateFormat format) {
        if (date == null) {
            return "unspecified";
        }
        if (format == null) {
            return String.valueOf(date);
        }
        return format.format(date);
    }

    public static String formatTimestamp(long millis, DateFormat format) {
        Date date = millis == Long.MIN_VALUE ? null : new Date(millis);
        return FileJournalUtil.formatTimestamp(date, format);
    }

    public static String formatEntry(FileJournalEntry entry, FileJournalEntry old) {
        return FileJournalUtil.formatEntry(entry, old, false, false, null);
    }

    public static String formatEntry(FileJournalEntry entry, FileJournalEntry old, boolean includeChecksum, boolean includeTimestamp, DateFormat dateFormat) {
        String path;
        byte[] md5checksum;
        StringBuffer sb = new StringBuffer();
        if (includeTimestamp) {
            sb.append(FileJournalUtil.formatTimestamp(entry.getTimestamp(), dateFormat));
            sb.append(" ");
        }
        if (entry.isExisting()) {
            if (old != null && old.isExisting()) {
                sb.append("Update ");
            } else {
                sb.append("Insert ");
            }
        } else {
            sb.append("Delete ");
        }
        byte type = entry.getType();
        switch (type) {
            case 1: {
                sb.append("File: ");
                break;
            }
            case 2: {
                sb.append("Directory: ");
                break;
            }
            case 3: {
                sb.append("SymLink: ");
                break;
            }
            default: {
                sb.append("Other#");
                sb.append(entry.getType());
                sb.append(": ");
            }
        }
        if (includeChecksum && (md5checksum = entry.getMd5Checksum()) != null) {
            int len = md5checksum.length;
            char[] chars = new char[len * 2];
            FileJournalUtil.formatHex(md5checksum, chars, 0);
            sb.append("MD5#");
            sb.append(new String(chars));
            sb.append(" ");
        }
        if ((path = entry.getPath()) != null) {
            sb.append(path);
        }
        if (entry.isSymbolicLink()) {
            sb.append(" -> ");
            sb.append(entry.getLinkTarget());
        }
        return sb.toString();
    }

    public static String formatEntry(FileJournalEntry entry, boolean includeType) {
        String path;
        StringBuffer sb = new StringBuffer();
        if (includeType) {
            byte type = entry.getType();
            switch (type) {
                case 1: {
                    sb.append("File: ");
                    break;
                }
                case 2: {
                    sb.append("Directory: ");
                    break;
                }
                case 3: {
                    sb.append("SymLink: ");
                    break;
                }
                default: {
                    sb.append("Other#");
                    sb.append(entry.getType());
                    sb.append(": ");
                }
            }
        }
        if ((path = entry.getPath()) != null) {
            sb.append(path);
        }
        return sb.toString();
    }

    public static String formatType(byte type) {
        switch (type) {
            case 1: {
                return "File";
            }
            case 2: {
                return "Directory";
            }
            case 3: {
                return "SymLink";
            }
        }
        return "Other#" + type;
    }

    public static String formatEscapePath(String path) {
        int x;
        int from = 0;
        while ((x = path.indexOf(34, from)) >= 0) {
            path = path.substring(0, x) + "\\\"" + path.substring(x + 1);
            from = x + 2;
        }
        return "\"" + path + "\"";
    }
}

