/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.filetools.journal.impl;

import com.spacekiller.filetools.journal.FileJournal;
import com.spacekiller.filetools.journal.FileJournalCursor;
import com.spacekiller.filetools.journal.FileJournalEntry;
import com.spacekiller.filetools.journal.impl.AbstractFileJournal;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.StreamCorruptedException;

public class FileJournalV1
extends AbstractFileJournal {
    private static final int VERSION_1 = 1;
    private static final int VERSION = 1;
    private static final int HEADER_LENGTH = 24;
    private static final int HEADER_MAGIC = -1712251380;
    private static final int FOOTER_MAGIC = 871439879;
    private static final int TAG_ENTRY = 2007914545;
    private static final int MAX_ENTRY_SIZE = 16384;
    private RandomAccessFile raf;
    private boolean closed;
    private long firstOffset;
    private long footerOffset;
    private AbstractFileJournal.Baos baos = new AbstractFileJournal.Baos();
    private DataOutputStream dos = new DataOutputStream(this.baos);
    private AbstractFileJournal.Bais bais = new AbstractFileJournal.Bais(new byte[1024]);
    private DataInputStream dis = new DataInputStream(this.bais);

    public FileJournalV1(File journalFile, boolean readOnly) throws IOException {
        super(journalFile, readOnly);
        boolean exists = journalFile.exists();
        String mode = readOnly ? "r" : "rw";
        this.raf = new RandomAccessFile(journalFile, mode);
        if (exists) {
            this.readHeader();
            this.readFooter();
        } else {
            this.writeHeader();
            this.footerOffset = this.firstOffset = 24L;
        }
    }

    protected synchronized void writeHeader() throws IOException {
        this.raf.seek(0L);
        this.raf.writeInt(-1712251380);
        this.raf.writeInt(1);
        this.raf.writeLong(this.firstOffset);
        this.raf.writeLong(this.footerOffset);
    }

    protected synchronized void readHeader() throws IOException {
        this.raf.seek(0L);
        int magic = this.raf.readInt();
        if (magic != -1712251380) {
            throw new StreamCorruptedException("Invalid journal file magic: " + magic + " != " + -1712251380);
        }
        int version = this.raf.readInt();
        if (version < 0 || version > 1) {
            throw new StreamCorruptedException("Invalid journal file version: " + version);
        }
        long first = this.raf.readLong();
        if (first < 24L) {
            throw new StreamCorruptedException("Invalid journal file entry offset: " + first + " < " + 24);
        }
        long footer = this.raf.readLong();
        if (footer < first) {
            throw new StreamCorruptedException("Invalid journal file footer offset: " + footer + " < " + first);
        }
        this.firstOffset = first;
        this.footerOffset = footer;
    }

    protected synchronized void writeFooter() throws IOException {
        this.raf.seek(this.footerOffset);
        this.raf.writeInt(871439879);
    }

    protected synchronized void readFooter() throws IOException {
        this.raf.seek(this.footerOffset);
        int magic = this.raf.readInt();
        if (magic != 871439879) {
            throw new StreamCorruptedException("Invalid journal file footer: " + magic + " != " + 871439879);
        }
    }

    @Override
    public synchronized void flush() throws IOException {
        if (!this.readOnly) {
            this.writeHeader();
            this.writeFooter();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws IOException {
        if (this.closed) {
            return;
        }
        try {
            this.flush();
            this.raf.close();
            this.dos.close();
            this.baos.close();
        }
        finally {
            this.closed = true;
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public synchronized void appendEntry(FileJournalEntry entry) throws IOException {
        this.raf.seek(this.footerOffset);
        this.writeEntry(entry);
        this.footerOffset = this.raf.getFilePointer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void writeEntry(FileJournalEntry entry) throws IOException {
        try {
            this.baos.reset();
            entry.write(this.dos);
        }
        finally {
            this.dos.flush();
        }
        int len = this.baos.size();
        byte[] buf = this.baos.getBuffer();
        this.raf.writeInt(2007914545);
        this.raf.writeInt(len);
        this.raf.write(buf, 0, len);
    }

    @Override
    public FileJournalCursor createCursor() {
        return new Cursor(this.firstOffset);
    }

    protected synchronized long loadEntry(long offset, FileJournalEntry entry) throws IOException {
        this.raf.seek(offset);
        this.readEntry(entry);
        return this.raf.getFilePointer();
    }

    protected synchronized void readEntry(FileJournalEntry entry) throws IOException {
        int tag = this.raf.readInt();
        if (tag != 2007914545) {
            throw new StreamCorruptedException("Invalid journal entry tag: " + tag + " (offset=" + this.raf.getFilePointer() + ")");
        }
        int len = this.raf.readInt();
        if (len < 0 || len > 16384) {
            throw new StreamCorruptedException("Invalid journal entry size: " + len);
        }
        byte[] buf = this.bais.getBuffer();
        if (len > buf.length) {
            buf = new byte[len];
        }
        this.raf.readFully(buf, 0, len);
        this.bais.reset(buf, 0, len);
        entry.read(this.dis);
    }

    protected class Cursor
    implements FileJournalCursor {
        private long offset;
        private FileJournalEntry current;

        public Cursor(long ofs) {
            this.offset = ofs;
        }

        @Override
        public void close() {
            this.offset = -1L;
            this.current = null;
        }

        @Override
        public boolean hasNext() {
            return this.offset < FileJournalV1.this.footerOffset;
        }

        @Override
        public FileJournalEntry nextEntry() throws IOException {
            this.current = new FileJournalEntry();
            this.offset = FileJournalV1.this.loadEntry(this.offset, this.current);
            return this.current;
        }

        @Override
        public FileJournalEntry getEntry() {
            return this.current;
        }

        @Override
        public FileJournal getJournal() {
            return FileJournalV1.this;
        }
    }
}

