/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.filetools.journal.impl;

import com.spacekiller.filetools.journal.FileJournal;
import com.spacekiller.filetools.journal.FileJournalCursor;
import com.spacekiller.filetools.journal.FileJournalEntry;
import com.spacekiller.filetools.journal.impl.AbstractFileJournal;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.StreamCorruptedException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class FileJournalV2
extends AbstractFileJournal {
    private static final int VERSION_2 = 2;
    private static final int VERSION = 2;
    private static final int HEADER_LENGTH = 24;
    private static final int BLOCK_HEADER_LENGTH = 8;
    private static final int HEADER_MAGIC = -1712251380;
    private static final int FOOTER_MAGIC = 871439879;
    private static final int NEW_MAGIC = 953634449;
    private static final int BLOCK_MAGIC = -1278815609;
    private static final int ZIP_MAGIC = -991499821;
    private static final int ENTRY_MAGIC = 2007914545;
    private static final String ZIP_ENTRY_NAME = "bfj";
    private static final int MB = 0x100000;
    private static final int MAX_BLOCK_LENGTH = 0x10000000;
    private static final int DEFAULT_FLUSH_THRESHOLD = 0x100000;
    private RandomAccessFile raf;
    private boolean closed;
    private int version;
    private long firstOffset;
    private long reserved;
    private long footerOffset;
    private Block firstBlock;
    private Block lastBlock;
    private NewBlock newBlock;
    private int flushThreshold = 0x100000;
    private boolean uncompressed;
    private AbstractFileJournal.Baos baos = new AbstractFileJournal.Baos();
    private DataOutputStream dos = new DataOutputStream(this.baos);

    public FileJournalV2(File journalFile, boolean readOnly) throws IOException {
        super(journalFile, readOnly);
        String mode = readOnly ? "r" : "rw";
        this.raf = new RandomAccessFile(journalFile, mode);
        if (this.raf.length() > 0L) {
            this.readHeader();
            this.readBlocks();
        } else {
            this.version = 2;
            this.footerOffset = this.firstOffset = 24L;
            this.writeHeader();
            this.writeFooter();
        }
    }

    protected synchronized void writeHeader() throws IOException {
        this.raf.seek(0L);
        this.raf.writeInt(-1712251380);
        this.raf.writeInt(2);
        this.version = 2;
        this.raf.writeLong(this.firstOffset);
        this.raf.writeLong(this.reserved);
    }

    protected synchronized void readHeader() throws IOException {
        this.raf.seek(0L);
        int magic = this.raf.readInt();
        if (magic != -1712251380) {
            throw new StreamCorruptedException("Invalid journal file magic: " + magic + " != " + -1712251380);
        }
        int version = this.raf.readInt();
        if (version < 0 || version > 2) {
            throw new StreamCorruptedException("Invalid journal file version: " + version);
        }
        long first = this.raf.readLong();
        if (first < 24L) {
            throw new StreamCorruptedException("Invalid journal file block offset: " + first + " < " + 24);
        }
        long reserved = this.raf.readLong();
        this.version = version;
        this.firstOffset = first;
        this.reserved = reserved;
        this.footerOffset = -1L;
    }

    protected synchronized void readBlocks() throws IOException {
        long blockOffset = this.firstOffset;
        while (true) {
            Block block;
            this.raf.seek(blockOffset);
            int blockType = this.raf.readInt();
            if (blockType == 871439879) break;
            int blockLen = this.raf.readInt();
            if (blockLen < 8) {
                throw new StreamCorruptedException("Invalid journal block length: " + blockLen);
            }
            switch (blockType) {
                case -1278815609: {
                    if (blockLen > 0x10000000) {
                        throw new StreamCorruptedException("Invalid journal block length: " + blockLen + " > " + 0x10000000);
                    }
                    block = new NormalBlock(blockType, blockOffset, blockLen);
                    break;
                }
                case -991499821: {
                    if (blockLen > 0x10000000) {
                        throw new StreamCorruptedException("Invalid journal block length: " + blockLen + " > " + 0x10000000);
                    }
                    block = new ZipBlock(blockType, blockOffset, blockLen);
                    break;
                }
                case 2007914545: {
                    long legacyBlockLen = this.reserved - blockOffset;
                    if (legacyBlockLen < 0L || legacyBlockLen > Integer.MAX_VALUE) {
                        throw new StreamCorruptedException("Invalid legacy journal block length: " + legacyBlockLen);
                    }
                    blockLen = (int)legacyBlockLen;
                    block = new LegacyBlock(blockType, blockOffset, blockLen);
                    break;
                }
                default: {
                    throw new StreamCorruptedException("Invalid block type #" + blockType + " at offset " + blockOffset);
                }
            }
            block.prev = this.lastBlock;
            if (this.lastBlock == null) {
                this.firstBlock = block;
            } else {
                this.lastBlock.next = block;
            }
            this.lastBlock = block;
            blockOffset += (long)blockLen;
        }
        this.footerOffset = blockOffset;
    }

    protected synchronized int load(long offset, byte[] dst, int off, int len) throws IOException {
        this.raf.seek(offset);
        return this.raf.read(dst, off, len);
    }

    protected synchronized int load(long offset) throws IOException {
        this.raf.seek(offset);
        return this.raf.read();
    }

    protected synchronized void writeFooter() throws IOException {
        this.raf.seek(this.footerOffset);
        this.raf.writeInt(871439879);
    }

    @Override
    public synchronized void flush() throws IOException {
        if (this.readOnly || this.newBlock == null) {
            return;
        }
        this.flushNewBlock(this.newBlock);
        this.newBlock = null;
        if (this.version < 2) {
            this.writeHeader();
        }
        this.writeFooter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws IOException {
        if (this.closed) {
            return;
        }
        try {
            this.flush();
            this.raf.close();
        }
        finally {
            this.closed = true;
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public FileJournalCursor createCursor() throws IOException {
        return new Cursor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InputStream createZipInputStream(ZipBlock block) throws IOException {
        boolean done = false;
        long offset = block.offset + 8L;
        long length = block.length - 8;
        BlockStream bin = new BlockStream(offset, offset + length);
        try {
            ZipInputStream zin = new ZipInputStream(bin);
            ZipEntry entry = zin.getNextEntry();
            if (entry == null) {
                throw new StreamCorruptedException("No zip block entry: " + block);
            }
            String name = entry.getName();
            if (!ZIP_ENTRY_NAME.equals(name)) {
                throw new StreamCorruptedException("Invalid zip block entry name: " + name + " != " + ZIP_ENTRY_NAME);
            }
            BufferedInputStream bis = new BufferedInputStream(zin);
            done = true;
            BufferedInputStream bufferedInputStream = bis;
            return bufferedInputStream;
        }
        finally {
            if (!done) {
                bin.close();
            }
        }
    }

    protected InputStream createBlockInputStream(NormalBlock block) throws IOException {
        long offset = block.offset + 8L;
        long length = block.length - 8;
        BlockStream bin = new BlockStream(offset, offset + length);
        return new BufferedInputStream(bin);
    }

    protected InputStream createLegacyInputStream(LegacyBlock block) throws IOException {
        long offset = block.offset;
        int length = block.length;
        BlockStream bin = new BlockStream(offset, offset + (long)length);
        return new BufferedInputStream(bin);
    }

    protected synchronized Block nextBlock(Block block) {
        return block.next;
    }

    @Override
    public synchronized void appendEntry(FileJournalEntry entry) throws IOException {
        this.baos.reset();
        this.dos.writeInt(-1);
        this.dos.writeInt(-1);
        entry.write(this.dos);
        byte[] buf = this.baos.getBuffer();
        int len = this.baos.size();
        this.baos.reset();
        this.dos.writeInt(2007914545);
        this.dos.writeInt(len - 8);
        NewBlock block = this.newBlock;
        if (block == null) {
            Block lblk = this.lastBlock;
            if (lblk != null) {
                if (lblk instanceof LegacyBlock) {
                    LegacyBlock legacy = (LegacyBlock)lblk;
                    lblk = this.migrateLegacyBlock(legacy);
                }
                if (lblk instanceof NormalBlock) {
                    // empty if block
                }
            }
            block = new NewBlock(953634449);
            block.prev = this.lastBlock;
            if (this.lastBlock == null) {
                this.firstBlock = block;
            } else {
                this.lastBlock.next = block;
            }
            this.lastBlock = block;
            this.newBlock = block;
        }
        block.append(buf, 0, len);
        if (block.length >= this.flushThreshold) {
            this.flushNewBlock(block);
            this.newBlock = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized Block migrateLegacyBlock(LegacyBlock legacy) throws IOException {
        long offset = legacy.offset;
        int length = legacy.length;
        int bufSize = 16384;
        byte[] buf = new byte[bufSize];
        NewBlock newBlock = new NewBlock(953634449);
        InputStream in = legacy.createInputStream();
        try {
            int n;
            while ((n = in.read(buf)) >= 0) {
                newBlock.append(buf, 0, n);
            }
            if (newBlock.length != length) {
                throw new StreamCorruptedException("Invalid legacy block length: " + newBlock.length + " != " + length);
            }
        }
        finally {
            in.close();
        }
        this.footerOffset = offset;
        Block migratedBlock = this.flushNewBlock(newBlock);
        this.raf.setLength(this.footerOffset);
        this.writeFooter();
        return migratedBlock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized Block flushNewBlock(NewBlock newBlock) throws IOException {
        Block block;
        int blockLength;
        long blockOffset = this.footerOffset;
        if (this.uncompressed) {
            int blockType = -1278815609;
            blockLength = 8 + newBlock.length;
            this.raf.seek(blockOffset);
            this.raf.writeInt(blockType);
            this.raf.writeInt(blockLength);
            newBlock.flush(this.raf);
            block = new NormalBlock(blockType, blockOffset, blockLength);
        } else {
            int blockType = -991499821;
            AbstractFileJournal.Baos baos = new AbstractFileJournal.Baos();
            ZipOutputStream zos = new ZipOutputStream(baos);
            try {
                ZipEntry entry = new ZipEntry(ZIP_ENTRY_NAME);
                zos.putNextEntry(entry);
                newBlock.flush(zos);
                zos.closeEntry();
                zos.finish();
                zos.flush();
                int dataLength = baos.size();
                byte[] zip = baos.getBuffer();
                blockLength = 8 + dataLength;
                this.raf.seek(blockOffset);
                this.raf.writeInt(blockType);
                this.raf.writeInt(blockLength);
                this.raf.write(zip, 0, dataLength);
            }
            finally {
                zos.close();
            }
            block = new ZipBlock(blockType, blockOffset, blockLength);
        }
        this.footerOffset = blockOffset + (long)blockLength;
        this.writeFooter();
        block.prev = newBlock.prev;
        block.next = newBlock.next;
        if (block.prev == null) {
            this.firstBlock = block;
        } else {
            block.prev.next = block;
        }
        if (block.next == null) {
            this.lastBlock = block;
        } else {
            block.next.prev = block;
        }
        return block;
    }

    public boolean isUncompressed() {
        return this.uncompressed;
    }

    public void setUncompressed(boolean uncompressed) {
        this.uncompressed = uncompressed;
    }

    protected class Cursor
    implements FileJournalCursor {
        private Block block;
        private DataInputStream input;
        private FileJournalEntry currEntry;
        private FileJournalEntry nextEntry;

        public Cursor() throws IOException {
            this.block = FileJournalV2.this.firstBlock;
            this.jump();
        }

        @Override
        public void close() throws IOException {
            this.currEntry = null;
            this.nextEntry = null;
            this.block = null;
            if (this.input != null) {
                this.input.close();
                this.input = null;
            }
        }

        @Override
        public boolean hasNext() throws IOException {
            return this.nextEntry != null;
        }

        @Override
        public FileJournalEntry nextEntry() throws IOException {
            this.currEntry = this.nextEntry;
            this.jump();
            return this.currEntry;
        }

        @Override
        public FileJournalEntry getEntry() {
            return this.currEntry;
        }

        @Override
        public FileJournal getJournal() {
            return FileJournalV2.this;
        }

        protected void jump() throws IOException {
            int len;
            int type;
            if (this.block == null) {
                this.nextEntry = null;
                return;
            }
            FileJournalEntry entry = new FileJournalEntry();
            while (true) {
                try {
                    if (this.input == null) {
                        this.input = new DataInputStream(this.block.createInputStream());
                    }
                    type = this.input.readInt();
                    len = this.input.readInt();
                }
                catch (EOFException e) {
                    this.block = FileJournalV2.this.nextBlock(this.block);
                    if (this.block == null) {
                        this.nextEntry = null;
                        return;
                    }
                    if (this.input != null) {
                        this.input.close();
                    }
                    this.input = null;
                    continue;
                }
                break;
            }
            switch (type) {
                case 2007914545: {
                    entry.read(this.input);
                    this.nextEntry = entry;
                    return;
                }
            }
            throw new StreamCorruptedException("Invalid block entry: type=" + type + ", len=" + len + ", block=" + this.block);
        }
    }

    protected class BlockStream
    extends InputStream {
        private long ofs;
        private long end;

        public BlockStream(long ofs, long end) {
            this.ofs = ofs;
            this.end = end;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int n = (int)Math.min((long)len, this.end - this.ofs);
            if (n < 1) {
                return -1;
            }
            int r = FileJournalV2.this.load(this.ofs, b, off, n);
            if (r > 0) {
                this.ofs += (long)r;
            }
            return r;
        }

        @Override
        public int read() throws IOException {
            if (this.ofs >= this.end) {
                return -1;
            }
            int r = FileJournalV2.this.load(this.ofs);
            if (r < 0) {
                return -1;
            }
            ++this.ofs;
            return r;
        }
    }

    protected class LegacyBlock
    extends Block {
        public LegacyBlock(int type, long offset, int length) {
            super(type, offset, length);
        }

        @Override
        public InputStream createInputStream() throws IOException {
            return FileJournalV2.this.createLegacyInputStream(this);
        }
    }

    protected class NormalBlock
    extends Block {
        public NormalBlock(int type, long offset, int length) {
            super(type, offset, length);
        }

        @Override
        public InputStream createInputStream() throws IOException {
            return FileJournalV2.this.createBlockInputStream(this);
        }
    }

    protected class ZipBlock
    extends Block {
        public ZipBlock(int type, long offset, int length) {
            super(type, offset, length);
        }

        @Override
        public InputStream createInputStream() throws IOException {
            return FileJournalV2.this.createZipInputStream(this);
        }
    }

    protected class NewBlock
    extends Block {
        private AbstractFileJournal.Baos baos;

        public NewBlock(int type) throws IOException {
            super(type, -1L, 0);
            this.offset = -1L;
            this.length = 0;
            this.baos = new AbstractFileJournal.Baos();
        }

        @Override
        public synchronized InputStream createInputStream() throws IOException {
            byte[] buf = this.baos.getBuffer();
            return new ByteArrayInputStream(buf, 0, this.length);
        }

        public synchronized void flush(RandomAccessFile raf) throws IOException {
            byte[] buf = this.baos.getBuffer();
            raf.write(buf, 0, this.length);
        }

        public synchronized void flush(OutputStream out) throws IOException {
            byte[] buf = this.baos.getBuffer();
            out.write(buf, 0, this.length);
        }

        public synchronized void append(byte[] b, int off, int len) throws IOException {
            if (len < 1) {
                return;
            }
            this.baos.write(b, off, len);
            this.length += len;
        }

        public synchronized void close() throws IOException {
            this.baos.close();
        }
    }

    protected abstract class Block {
        protected Block prev;
        protected Block next;
        protected int type;
        protected long offset;
        protected int length;

        public Block(int type, long offset, int length) {
            this.type = type;
            this.offset = offset;
            this.length = length;
        }

        public String toString() {
            return super.toString() + "[offset=" + this.offset + ", length=" + this.length + "]";
        }

        public abstract InputStream createInputStream() throws IOException;
    }
}

