/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.filetools.journal.impl;

import com.spacekiller.filetools.journal.FileJournal;
import com.spacekiller.filetools.journal.FileJournalCursor;
import com.spacekiller.filetools.journal.FileJournalEntry;
import com.spacekiller.filetools.journal.FileJournalMap;
import com.spacekiller.util.large.LargeMap;
import java.io.IOException;
import java.util.Iterator;

public class LargeFileJournalMap
implements FileJournalMap {
    protected LargeMap map;

    public LargeFileJournalMap(LargeMap map) {
        this.map = map;
    }

    @Override
    public long size() {
        return this.map.longSize();
    }

    @Override
    public void close() throws IOException {
        if (this.map != null) {
            this.map = null;
        }
    }

    @Override
    public FileJournalEntry get(String key) throws IOException {
        return (FileJournalEntry)this.map.get(key);
    }

    @Override
    public FileJournalEntry put(String key, FileJournalEntry entry) throws IOException {
        return this.map.put(key, entry);
    }

    @Override
    public FileJournalEntry remove(String key) throws IOException {
        return (FileJournalEntry)this.map.remove(key);
    }

    @Override
    public FileJournalCursor createCursor() throws IOException {
        return new CursorImpl();
    }

    protected class CursorImpl
    implements FileJournalCursor {
        private FileJournalEntry entry;
        private Iterator iter;

        public CursorImpl() throws IOException {
            this.iter = LargeFileJournalMap.this.map.entrySet().iterator();
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public boolean hasNext() throws IOException {
            return this.iter.hasNext();
        }

        @Override
        public FileJournalEntry nextEntry() throws IOException {
            this.entry = (FileJournalEntry)this.iter.next();
            return this.entry;
        }

        @Override
        public FileJournalEntry getEntry() {
            return this.entry;
        }

        @Override
        public FileJournal getJournal() {
            throw new UnsupportedOperationException();
        }
    }
}

