/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.filetools.journal.impl;

import com.spacekiller.filetools.journal.FileJournalCursor;
import com.spacekiller.filetools.journal.FileJournalEntry;
import com.spacekiller.filetools.journal.FileJournalMap;
import com.spacekiller.filetools.journal.impl.BaseFileJournalAction;
import com.spacekiller.filetools.journal.impl.FileJournalUtil;
import com.spacekiller.filetools.journal.impl.LatestFileJournalWalker;
import com.spacekiller.filetools.journal.impl.ListDescendingComparator;
import java.util.Map;
import java.util.TreeMap;

public class ListFileJournalAction
extends BaseFileJournalAction {
    private boolean includeMissing;
    private boolean missingOnly;
    private boolean ignoreFiles;
    private boolean ignoreDirs;
    private boolean ignoreLinks;
    private boolean pathOnly;
    private boolean ascending;
    private boolean descending;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute() throws Exception {
        boolean valid = true;
        if (this.journalPath == null) {
            valid = false;
            this.error("Missing argument: [journalFilePath]");
        }
        if (!valid) {
            return false;
        }
        if (this.verbose) {
            this.verbose("Loading latest journal entries...");
        }
        FileJournalMap latestEntryMap = this.createFileJournalMap();
        try {
            FileJournalEntry entry;
            boolean compareTimestamp = !this.sequential;
            LatestFileJournalWalker walker = new LatestFileJournalWalker(compareTimestamp, latestEntryMap);
            walker.setStartDate(this.startDate);
            walker.setUntilDate(this.untilDate);
            walker.setFilter(this.filter);
            walker.setReplacer(this.replacer);
            boolean journalFileMustExist = true;
            FileJournalCursor cursor = this.createFileJournalCursor(journalFileMustExist);
            try {
                this.walkFileJournal(cursor, walker);
            }
            finally {
                cursor.close();
            }
            if (this.verbose) {
                this.verbose("Number of walked journal entries: " + walker.getWalkCount());
                this.verbose("Number of latest journal entries: " + latestEntryMap.size());
            }
            if (this.verbose) {
                this.verbose("Listing journal entry paths...");
            }
            long countFiles = 0L;
            long countDirs = 0L;
            long countLinks = 0L;
            TreeMap<String, FileJournalEntry> sorted = null;
            if (this.ascending) {
                sorted = new TreeMap<String, FileJournalEntry>();
            } else if (this.descending) {
                sorted = new TreeMap(new ListDescendingComparator());
            }
            FileJournalCursor latestCursor = latestEntryMap.createCursor();
            try {
                block14: while (latestCursor.hasNext()) {
                    entry = latestCursor.nextEntry();
                    if (!this.includeMissing && !entry.isExisting() || this.missingOnly && entry.isExisting()) continue;
                    byte type = entry.getType();
                    switch (type) {
                        case 1: {
                            if (this.ignoreFiles) continue block14;
                            ++countFiles;
                            break;
                        }
                        case 2: {
                            if (this.ignoreDirs) continue block14;
                            ++countDirs;
                            break;
                        }
                        case 3: {
                            if (this.ignoreLinks) continue block14;
                            ++countLinks;
                        }
                    }
                    if (sorted == null) {
                        this.list(entry);
                        continue;
                    }
                    sorted.put(entry.getPath(), entry);
                }
            }
            finally {
                latestCursor.close();
            }
            if (sorted != null) {
                for (Map.Entry me : sorted.entrySet()) {
                    entry = (FileJournalEntry)me.getValue();
                    this.list(entry);
                }
            }
            if (this.verbose && !this.ignoreFiles) {
                this.verbose("Number of files: " + countFiles);
            }
            if (this.verbose && !this.ignoreDirs) {
                this.verbose("Number of directories: " + countDirs);
            }
            if (this.verbose && !this.ignoreLinks) {
                this.verbose("Number of symlinks: " + countLinks);
            }
        }
        finally {
            latestEntryMap.close();
        }
        return true;
    }

    protected void list(FileJournalEntry entry) {
        boolean includeType = !this.pathOnly;
        this.info(FileJournalUtil.formatEntry(entry, includeType));
    }

    public boolean isIncludeMissing() {
        return this.includeMissing;
    }

    public void setIncludeMissing(boolean includeMissing) {
        this.includeMissing = includeMissing;
    }

    public boolean isMissingOnly() {
        return this.missingOnly;
    }

    public void setMissingOnly(boolean missingOnly) {
        this.missingOnly = missingOnly;
    }

    public boolean isIgnoreFiles() {
        return this.ignoreFiles;
    }

    public void setIgnoreFiles(boolean ignoreFiles) {
        this.ignoreFiles = ignoreFiles;
    }

    public boolean isIgnoreDirs() {
        return this.ignoreDirs;
    }

    public void setIgnoreDirs(boolean ignoreDirs) {
        this.ignoreDirs = ignoreDirs;
    }

    public boolean isIgnoreLinks() {
        return this.ignoreLinks;
    }

    public void setIgnoreLinks(boolean ignoreLinks) {
        this.ignoreLinks = ignoreLinks;
    }

    public boolean isPathOnly() {
        return this.pathOnly;
    }

    public void setPathOnly(boolean pathOnly) {
        this.pathOnly = pathOnly;
    }

    public boolean isAscending() {
        return this.ascending;
    }

    public void setAscending(boolean ascending) {
        this.ascending = ascending;
    }

    public boolean isDescending() {
        return this.descending;
    }

    public void setDescending(boolean descending) {
        this.descending = descending;
    }
}

