/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.filetools.journal.impl;

import com.spacekiller.filetools.journal.FileJournal;
import com.spacekiller.filetools.journal.FileJournalCursor;
import com.spacekiller.filetools.journal.FileJournalEntry;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class MultiFileJournalCursor
implements FileJournalCursor {
    private final boolean sequential;
    private Map journalWrapperMap;
    private FileJournalWrapper first;
    private FileJournalWrapper last;
    private FileJournalEntry current;
    private FileJournalWrapper wrapper;
    private FileJournalEntry nextEntry;
    private FileJournalWrapper nextWrapper;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MultiFileJournalCursor(FileJournal[] fileJournals, boolean sequential) throws IOException {
        this.sequential = sequential;
        this.journalWrapperMap = new HashMap();
        boolean success = false;
        try {
            for (int i = 0; i < fileJournals.length; ++i) {
                FileJournalCursor cursor;
                FileJournal journal = fileJournals[i];
                FileJournalWrapper wrapper = new FileJournalWrapper();
                wrapper.journal = journal;
                this.journalWrapperMap.put(journal, wrapper);
                wrapper.prev = this.last;
                if (this.last == null) {
                    this.first = wrapper;
                } else {
                    this.last.next = wrapper;
                }
                this.last = wrapper;
                wrapper.cursor = cursor = journal.createCursor();
                if (cursor.hasNext()) {
                    wrapper.entry = cursor.nextEntry();
                    continue;
                }
                this.disposeWrapper(wrapper);
            }
            this.jump();
            success = true;
        }
        finally {
            if (!success) {
                this.close();
            }
        }
    }

    @Override
    public boolean hasNext() throws IOException {
        return this.nextEntry != null;
    }

    @Override
    public FileJournalEntry nextEntry() throws IOException {
        this.current = this.nextEntry;
        this.wrapper = this.nextWrapper;
        this.jump();
        return this.current;
    }

    @Override
    public FileJournalEntry getEntry() {
        return this.current;
    }

    @Override
    public FileJournal getJournal() {
        FileJournalWrapper wrapper = this.wrapper;
        return wrapper == null ? null : wrapper.journal;
    }

    @Override
    public void close() throws IOException {
        this.nextEntry = null;
        this.nextWrapper = null;
        FileJournalWrapper wrapper = this.first;
        while (wrapper != null) {
            FileJournalWrapper nw = wrapper.next;
            this.disposeWrapper(wrapper);
            wrapper = nw;
        }
    }

    private void disposeWrapper(FileJournalWrapper wrapper) {
        if (wrapper.next == null) {
            if (wrapper == this.last) {
                this.last = wrapper.prev;
            }
        } else {
            wrapper.next.prev = wrapper.prev;
        }
        if (wrapper.prev == null) {
            if (wrapper == this.first) {
                this.first = wrapper.next;
            }
        } else {
            wrapper.prev.next = wrapper.next;
        }
        wrapper.prev = null;
        wrapper.next = null;
        FileJournalCursor cursor = wrapper.cursor;
        if (cursor != null) {
            try {
                cursor.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void jump() throws IOException {
        FileJournalWrapper wrapper;
        FileJournalEntry bestEntry = null;
        FileJournalWrapper bestWrapper = null;
        if (this.sequential) {
            wrapper = this.first;
            if (wrapper != null) {
                bestWrapper = wrapper;
                bestEntry = wrapper.entry;
            }
        } else {
            wrapper = this.first;
            long bestTime = Long.MIN_VALUE;
            while (wrapper != null) {
                FileJournalEntry entry = wrapper.entry;
                long time = entry.getTimestamp();
                if (bestEntry == null || time < bestTime) {
                    bestTime = time;
                    bestEntry = entry;
                    bestWrapper = wrapper;
                }
                wrapper = wrapper.next;
            }
        }
        this.nextEntry = bestEntry;
        this.nextWrapper = bestWrapper;
        if (bestEntry == null) {
            return;
        }
        FileJournalCursor bestCursor = bestWrapper.cursor;
        if (bestCursor.hasNext()) {
            bestWrapper.entry = bestCursor.nextEntry();
        } else {
            bestWrapper.entry = null;
            this.disposeWrapper(bestWrapper);
        }
    }

    protected static class FileJournalWrapper {
        protected FileJournalWrapper prev;
        protected FileJournalWrapper next;
        protected FileJournal journal;
        protected FileJournalCursor cursor;
        protected FileJournalEntry entry;

        protected FileJournalWrapper() {
        }
    }
}

