/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.filetools.journal.impl;

import com.spacekiller.filetools.journal.FileJournalFilter;

public class MultiFileJournalFilter
implements FileJournalFilter {
    private final FileJournalFilter[] includeArray;
    private final int includeCount;
    private final FileJournalFilter[] excludeArray;
    private final int excludeCount;

    public MultiFileJournalFilter(FileJournalFilter[] includeArray, FileJournalFilter[] excludeArray) {
        this.includeArray = includeArray;
        this.includeCount = includeArray == null ? 0 : includeArray.length;
        this.excludeArray = excludeArray;
        this.excludeCount = excludeArray == null ? 0 : excludeArray.length;
    }

    @Override
    public boolean accept(String path) {
        int i;
        boolean accept = true;
        if (this.includeCount > 0) {
            accept = false;
            for (i = 0; i < this.includeCount; ++i) {
                if (!this.includeArray[i].accept(path)) continue;
                accept = true;
                break;
            }
        }
        if (accept) {
            for (i = 0; i < this.excludeCount; ++i) {
                if (!this.excludeArray[i].accept(path)) continue;
                accept = false;
                break;
            }
        }
        return accept;
    }
}

