/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.filetools.journal.impl;

import com.spacekiller.filetools.journal.FileJournalCursor;
import com.spacekiller.filetools.journal.FileJournalEntry;
import com.spacekiller.filetools.journal.FileJournalMap;
import com.spacekiller.filetools.journal.impl.BaseFileJournalAction;
import com.spacekiller.filetools.journal.impl.FileJournalUtil;
import com.spacekiller.filetools.journal.impl.LatestFileJournalWalker;
import java.util.Map;
import java.util.TreeMap;

public class ReconstructFileJournalAction
extends BaseFileJournalAction {
    private boolean unix = true;
    private boolean windows;
    private boolean ignoreLinks;
    private boolean includeMissing;
    private boolean missingOnly;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute() throws Exception {
        boolean valid = true;
        if (this.journalPath == null) {
            valid = false;
            this.error("Missing argument: [journalFilePath]");
        }
        if (!valid) {
            return false;
        }
        if (this.verbose) {
            this.verbose("Loading latest journal entries...");
        }
        FileJournalMap latestEntryMap = this.createFileJournalMap();
        try {
            FileJournalEntry entry;
            boolean compareTimestamp = !this.sequential;
            LatestFileJournalWalker walker = new LatestFileJournalWalker(compareTimestamp, latestEntryMap);
            walker.setStartDate(this.startDate);
            walker.setUntilDate(this.untilDate);
            walker.setFilter(this.filter);
            walker.setReplacer(this.replacer);
            boolean journalFileMustExist = true;
            FileJournalCursor cursor = this.createFileJournalCursor(journalFileMustExist);
            try {
                this.walkFileJournal(cursor, walker);
            }
            finally {
                cursor.close();
            }
            if (this.verbose) {
                this.verbose("Number of walked journal entries: " + walker.getWalkCount());
                this.verbose("Number of latest journal entries: " + latestEntryMap.size());
            }
            if (this.verbose) {
                this.verbose("Generating commands...");
            }
            boolean ignoreLinks = this.ignoreLinks;
            if (this.windows && !this.unix) {
                ignoreLinks = true;
            }
            TreeMap<String, FileJournalEntry> sortedDirs = new TreeMap<String, FileJournalEntry>();
            TreeMap<String, FileJournalEntry> sortedLinks = new TreeMap<String, FileJournalEntry>();
            FileJournalCursor latestCursor = latestEntryMap.createCursor();
            try {
                while (latestCursor.hasNext()) {
                    entry = latestCursor.nextEntry();
                    if (!this.includeMissing && !entry.isExisting() || this.missingOnly && entry.isExisting()) continue;
                    byte type = entry.getType();
                    switch (type) {
                        case 1: {
                            break;
                        }
                        case 2: {
                            sortedDirs.put(entry.getPath(), entry);
                            break;
                        }
                        case 3: {
                            if (ignoreLinks) break;
                            sortedLinks.put(entry.getPath(), entry);
                        }
                    }
                }
            }
            finally {
                latestCursor.close();
            }
            long countDirs = 0L;
            if (sortedDirs != null) {
                for (Map.Entry me : sortedDirs.entrySet()) {
                    entry = (FileJournalEntry)me.getValue();
                    if (!this.generateDirectory(entry)) continue;
                    ++countDirs;
                }
            }
            long countLinks = 0L;
            if (sortedLinks != null && !ignoreLinks) {
                for (Map.Entry me : sortedLinks.entrySet()) {
                    entry = (FileJournalEntry)me.getValue();
                    if (!this.generateSymlink(entry)) continue;
                    ++countLinks;
                }
            }
            if (this.verbose) {
                this.verbose("Number of directories: " + countDirs);
            }
            if (this.verbose && !ignoreLinks) {
                this.verbose("Number of symlinks: " + countLinks);
            }
        }
        finally {
            latestEntryMap.close();
        }
        return true;
    }

    protected boolean generateDirectory(FileJournalEntry entry) {
        String dirPath;
        String command = null;
        if (this.unix) {
            String dirPath2 = entry.getPath();
            if (dirPath2 != null && dirPath2.length() > 0) {
                dirPath2 = dirPath2.replace('\\', '/');
                command = "mkdir " + FileJournalUtil.formatEscapePath(dirPath2);
            }
        } else if (this.windows && (dirPath = entry.getPath()) != null && dirPath.length() > 0) {
            dirPath = dirPath.replace('/', '\\');
            command = "md " + FileJournalUtil.formatEscapePath(dirPath);
        }
        if (command == null) {
            return false;
        }
        this.info(command);
        return true;
    }

    protected boolean generateSymlink(FileJournalEntry entry) {
        String command = null;
        if (this.unix) {
            String linkPath = entry.getPath();
            String linkTarget = entry.getLinkTarget();
            if (linkPath != null && linkPath.length() > 0 && linkTarget != null && linkTarget.length() > 0) {
                linkPath = linkPath.replace('\\', '/');
                linkTarget = linkTarget.replace('\\', '/');
                command = "ln -s " + FileJournalUtil.formatEscapePath(linkTarget) + " " + FileJournalUtil.formatEscapePath(linkPath);
            }
        }
        if (command == null) {
            return false;
        }
        this.info(command);
        return true;
    }

    public boolean isWindows() {
        return this.windows;
    }

    public void setWindows(boolean windows) {
        this.windows = windows;
        if (windows) {
            this.unix = false;
        }
    }

    public boolean isUnix() {
        return this.unix;
    }

    public void setUnix(boolean unix) {
        this.unix = unix;
        if (unix) {
            this.windows = false;
        }
    }

    public boolean isIgnoreLinks() {
        return this.ignoreLinks;
    }

    public void setIgnoreLinks(boolean ignoreLinks) {
        this.ignoreLinks = ignoreLinks;
    }

    public boolean isIncludeMissing() {
        return this.includeMissing;
    }

    public void setIncludeMissing(boolean includeMissing) {
        this.includeMissing = includeMissing;
    }

    public boolean isMissingOnly() {
        return this.missingOnly;
    }

    public void setMissingOnly(boolean missingOnly) {
        this.missingOnly = missingOnly;
    }
}

