/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.filetools.journal.impl;

import com.spacekiller.filetools.journal.FileJournal;
import com.spacekiller.filetools.journal.FileJournalCursor;
import com.spacekiller.filetools.journal.FileJournalFilter;
import com.spacekiller.filetools.journal.FileJournalMap;
import com.spacekiller.filetools.journal.impl.AbstractFileJournalAction;
import com.spacekiller.filetools.journal.impl.AbstractFileJournalScanner;
import com.spacekiller.filetools.journal.impl.FileJournalComparator;
import com.spacekiller.filetools.journal.impl.LatestFileJournalWalker;
import com.spacekiller.filetools.journal.j14.FileJournalScannerJ14;
import java.io.File;

public class ScanFileJournalAction
extends AbstractFileJournalAction {
    private static final String JAVA17_IMPL_CLASS = "com.spacekiller.filetools.journal.j17.FileJournalScannerJ17";
    private String basePath;
    private boolean java14;
    private boolean java17;
    private boolean summary;
    private boolean dryRun;
    private boolean sizeOnly;
    private boolean sumOnly;
    private boolean checksum;
    private boolean followSymlinks;
    private boolean ignoreMissing;
    private boolean ignoreErrors;
    private boolean uncompressed;
    private FileJournalFilter scanFilter;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public boolean execute() throws Exception {
        boolean valid = true;
        if (this.basePath == null) {
            valid = false;
            this.error("Missing argument: [basePath]");
        }
        if (this.journalPath == null) {
            valid = false;
            this.error("Missing argument: [journalPath]");
        }
        if (!valid) {
            return false;
        }
        if (this.verbose) {
            this.verbose("Loading latest journal entries...");
        }
        FileJournalMap latestEntryMap = this.createFileJournalMap();
        try {
            boolean bl;
            boolean compareTimestamp = !this.sequential;
            LatestFileJournalWalker walker = new LatestFileJournalWalker(compareTimestamp, latestEntryMap);
            boolean journalFileMustExist = false;
            FileJournalCursor cursor = this.createFileJournalCursor(journalFileMustExist);
            try {
                this.walkFileJournal(cursor, walker);
            }
            finally {
                cursor.close();
            }
            if (this.verbose) {
                this.verbose("Number of walked journal entries: " + walker.getWalkCount());
                this.verbose("Number of latest journal entries: " + latestEntryMap.size());
            }
            FileJournalComparator comparator = new FileJournalComparator();
            comparator.setSizeOnly(this.sizeOnly);
            comparator.setSumOnly(this.sumOnly);
            comparator.setChecksum(this.checksum);
            AbstractFileJournalScanner scanner = this.createFileJournalScanner(this.java14, this.java17);
            if (scanner == null) {
                valid = false;
                boolean bl2 = false;
                return bl2;
            }
            File baseDir = new File(this.basePath).getCanonicalFile();
            File journalFile = new File(this.journalPath);
            boolean readOnly = this.dryRun;
            FileJournal journal = this.openFileJournal(journalFile, readOnly, this.uncompressed);
            try {
                scanner.setLogger(this.logger);
                scanner.setDryRun(this.dryRun);
                scanner.setFollowSymlinks(this.followSymlinks);
                scanner.setIgnoreMissing(this.ignoreMissing);
                scanner.setIgnoreErrors(this.ignoreErrors);
                scanner.setVerbose(this.verbose);
                scanner.setDebug(this.debug);
                scanner.setBasePath(baseDir.getPath());
                scanner.setScanFilter(this.scanFilter);
                scanner.setIncludeFilter(this.filter);
                scanner.setReplacer(this.replacer);
                scanner.setComparator(comparator);
                scanner.setLatestEntryMap(latestEntryMap);
                scanner.setJournal(journal);
                scanner.scan();
                bl = true;
            }
            catch (Exception e) {
                boolean bl3;
                block22: {
                    this.error(e);
                    bl3 = false;
                    journal.close();
                    if (!this.summary) break block22;
                    long insertCount = scanner.getInsertCount();
                    long updateCount = scanner.getUpdateCount();
                    long removeCount = scanner.getRemoveCount();
                    long totalCount = insertCount + updateCount + removeCount;
                    this.info("Total changes: " + totalCount);
                    this.info(" - Insert changes: " + insertCount);
                    this.info(" - Update changes: " + updateCount);
                    this.info(" - Remove changes: " + removeCount);
                }
                latestEntryMap.close();
                return bl3;
                {
                    catch (Throwable throwable) {
                        journal.close();
                        if (this.summary) {
                            long insertCount = scanner.getInsertCount();
                            long updateCount = scanner.getUpdateCount();
                            long removeCount = scanner.getRemoveCount();
                            long totalCount = insertCount + updateCount + removeCount;
                            this.info("Total changes: " + totalCount);
                            this.info(" - Insert changes: " + insertCount);
                            this.info(" - Update changes: " + updateCount);
                            this.info(" - Remove changes: " + removeCount);
                        }
                        throw throwable;
                    }
                }
            }
            journal.close();
            if (this.summary) {
                long insertCount = scanner.getInsertCount();
                long updateCount = scanner.getUpdateCount();
                long removeCount = scanner.getRemoveCount();
                long totalCount = insertCount + updateCount + removeCount;
                this.info("Total changes: " + totalCount);
                this.info(" - Insert changes: " + insertCount);
                this.info(" - Update changes: " + updateCount);
                this.info(" - Remove changes: " + removeCount);
            }
            return bl;
        }
        finally {
            latestEntryMap.close();
        }
    }

    protected AbstractFileJournalScanner createFileJournalScanner(boolean java14, boolean java17) throws Exception {
        block5: {
            if (java17 || !java14) {
                try {
                    Class<?> java17Class = Class.forName(JAVA17_IMPL_CLASS);
                    AbstractFileJournalScanner scanner = (AbstractFileJournalScanner)java17Class.newInstance();
                    if (this.verbose) {
                        this.verbose("Using Java 1.7 implementation.");
                    }
                    return scanner;
                }
                catch (Throwable e) {
                    if (!java17 || java14) break block5;
                    this.error(e);
                    return null;
                }
            }
        }
        if (this.verbose) {
            this.verbose("Using Java 1.4 implementation.");
        }
        return new FileJournalScannerJ14();
    }

    public String getBasePath() {
        return this.basePath;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public boolean isJava14() {
        return this.java14;
    }

    public void setJava14(boolean java14) {
        this.java14 = java14;
    }

    public boolean isJava17() {
        return this.java17;
    }

    public void setJava17(boolean java17) {
        this.java17 = java17;
    }

    public boolean isDryRun() {
        return this.dryRun;
    }

    public void setDryRun(boolean dryRun) {
        this.dryRun = dryRun;
    }

    public boolean isSizeOnly() {
        return this.sizeOnly;
    }

    public void setSizeOnly(boolean sizeOnly) {
        this.sizeOnly = sizeOnly;
    }

    public boolean isChecksum() {
        return this.checksum;
    }

    public void setChecksum(boolean checksum) {
        this.checksum = checksum;
    }

    public boolean isFollowSymlinks() {
        return this.followSymlinks;
    }

    public void setFollowSymlinks(boolean followSymlinks) {
        this.followSymlinks = followSymlinks;
    }

    public boolean isIgnoreMissing() {
        return this.ignoreMissing;
    }

    public void setIgnoreMissing(boolean ignoreMissing) {
        this.ignoreMissing = ignoreMissing;
    }

    public boolean isIgnoreErrors() {
        return this.ignoreErrors;
    }

    public void setIgnoreErrors(boolean ignoreErrors) {
        this.ignoreErrors = ignoreErrors;
    }

    public boolean isUncompressed() {
        return this.uncompressed;
    }

    public void setUncompressed(boolean uncompressed) {
        this.uncompressed = uncompressed;
    }

    public boolean isSumOnly() {
        return this.sumOnly;
    }

    public void setSumOnly(boolean sumOnly) {
        this.sumOnly = sumOnly;
    }

    public boolean isSummary() {
        return this.summary;
    }

    public void setSummary(boolean summary) {
        this.summary = summary;
    }

    public FileJournalFilter getScanFilter() {
        return this.scanFilter;
    }

    public void setScanFilter(FileJournalFilter scanFilter) {
        this.scanFilter = scanFilter;
    }
}

